/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.morphia.mapping.validation.classrules;

import com.google.code.morphia.mapping.MappedClass;
import com.google.code.morphia.mapping.validation.ClassConstraint;
import com.google.code.morphia.mapping.validation.ConstraintViolation;
import java.lang.reflect.Modifier;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NonStaticInnerClasss
implements ClassConstraint {
    @Override
    public void check(MappedClass mc, Set<ConstraintViolation> ve) {
        Class<?> clazz = mc.getClazz();
        boolean isstatic = Modifier.isStatic(clazz.getModifiers());
        if (!isstatic && clazz.isMemberClass()) {
            ve.add(new ConstraintViolation(ConstraintViolation.Level.FATAL, mc, this.getClass(), "Inner class is not static"));
        }
    }
}

