/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.morphia.query;

import com.google.code.morphia.logging.Logr;
import com.google.code.morphia.logging.MorphiaLoggerFactory;
import com.google.code.morphia.mapping.MappedClass;
import com.google.code.morphia.mapping.MappedField;
import com.google.code.morphia.mapping.Mapper;
import com.google.code.morphia.query.AbstractCriteria;
import com.google.code.morphia.query.Criteria;
import com.google.code.morphia.query.FilterOperator;
import com.google.code.morphia.query.QueryImpl;
import com.google.code.morphia.utils.ReflectionUtils;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldCriteria
extends AbstractCriteria
implements Criteria {
    private static final Logr log = MorphiaLoggerFactory.get(FieldCriteria.class);
    protected final String field;
    protected final FilterOperator operator;
    protected final Object value;
    protected final boolean not;

    protected FieldCriteria(QueryImpl<?> query, String field, FilterOperator op, Object value, boolean validateNames, boolean validateTypes) {
        this(query, field, op, value, validateNames, validateTypes, false);
    }

    protected FieldCriteria(QueryImpl<?> query, String field, FilterOperator op, Object value, boolean validateNames, boolean validateTypes, boolean not) {
        Class<?> type;
        StringBuffer sb = new StringBuffer(field);
        MappedField mf = Mapper.validate(query.getEntityClass(), query.getDatastore().getMapper(), sb, op, value, validateNames, validateTypes);
        field = sb.toString();
        Mapper mapr = query.getDatastore().getMapper();
        MappedClass mc = null;
        try {
            if (value != null && !ReflectionUtils.isPropertyType(value.getClass()) && !ReflectionUtils.implementsInterface(value.getClass(), Iterable.class)) {
                mc = mf != null && !mf.isTypeMongoCompatible() ? mapr.getMappedClass(mf.isSingleValue() ? mf.getType() : mf.getSubClass()) : mapr.getMappedClass(value);
            }
        }
        catch (Exception e) {
            log.debug("Error during mapping of filter criteria: ", e);
        }
        List<Object> mappedValue = mapr.toMongoObject(mf, mc, value);
        Class<?> clazz = type = mappedValue == null ? null : mappedValue.getClass();
        if (!(type == null || op != FilterOperator.IN && op != FilterOperator.NOT_IN || type.isArray() || Iterable.class.isAssignableFrom(type))) {
            mappedValue = Collections.singletonList(mappedValue);
        }
        if (op == FilterOperator.ELEMENT_MATCH && mappedValue instanceof DBObject) {
            ((DBObject)mappedValue).removeField("_id");
        }
        this.field = field;
        this.operator = op;
        this.value = not ? new BasicDBObject("$not", mappedValue) : mappedValue;
        this.not = not;
    }

    @Override
    public void addTo(DBObject obj) {
        if (FilterOperator.EQUAL.equals((Object)this.operator)) {
            obj.put(this.field, this.value);
        } else {
            HashMap inner = obj.get(this.field);
            if (!(inner instanceof Map)) {
                inner = new HashMap();
                obj.put(this.field, inner);
            }
            Object val = this.not ? new BasicDBObject("$not", this.value) : this.value;
            ((Map)inner).put(this.operator.val(), val);
        }
    }

    public String toString() {
        return this.field + " " + this.operator.val() + " " + this.value;
    }
}

