/*
 * Decompiled with CFR 0.152.
 */
package play.modules.morphia.utils;

import java.util.Collection;
import java.util.Iterator;

public class StringUtil {
    public static final int IGNORECASE = 4096;
    public static final int IGNORESPACE = 8192;

    public static String join(String separator, Collection<?> list) {
        return StringUtil.join(separator, null, null, list);
    }

    public static String join(String separator, String prefix, String suffix, Collection<?> list) {
        Iterator<?> itr;
        StringBuilder sb = new StringBuilder();
        if (null != prefix) {
            sb.append(prefix).append(separator);
        }
        if ((itr = list.iterator()).hasNext()) {
            sb.append(itr.next());
        }
        while (itr.hasNext()) {
            sb.append(separator).append(itr.next());
        }
        if (null != suffix) {
            sb.append(separator).append(suffix);
        }
        return sb.toString();
    }

    public static String join(String separator, String ... list) {
        StringBuilder sb = new StringBuilder();
        if (list.length > 0) {
            sb.append(list[0]);
            for (int i = 1; i < list.length; ++i) {
                sb.append(separator).append(list[i]);
            }
        }
        return sb.toString();
    }

    public static boolean isEmpty(String s) {
        return null == s || "".equals(s.trim());
    }

    public static boolean isEqual(String s1, String s2) {
        return StringUtil.isEqual(s1, s2, 0);
    }

    public static boolean isEqual(String s1, String s2, int modifier) {
        if (null == s1) {
            return s2 == null;
        }
        if (null == s2) {
            return false;
        }
        if ((modifier & 0x2000) != 0) {
            s1 = s1.trim();
            s2 = s2.trim();
        }
        if ((modifier & 0x1000) != 0) {
            return s1.equalsIgnoreCase(s2);
        }
        return s1.equals(s2);
    }
}

