/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.morphia;

import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Key<T>
implements Serializable,
Comparable<Key<?>> {
    private static final long serialVersionUID = 1L;
    protected String kind;
    protected Class<? extends T> kindClass;
    protected Object id;
    protected byte[] idBytes;

    protected Key() {
    }

    public Key(Class<? extends T> kind, Object id) {
        this.kindClass = kind;
        this.id = id;
    }

    public Key(Class<? extends T> kind, byte[] idBytes) {
        this.kindClass = kind;
        this.idBytes = idBytes;
    }

    public Key(String kind, Object id) {
        this.kind = kind;
        this.id = id;
    }

    public Object getId() {
        return this.id;
    }

    public String getKind() {
        return this.kind;
    }

    public void setKind(String newKind) {
        this.kind = newKind;
    }

    public void setKindClass(Class<? extends T> clazz) {
        this.kindClass = clazz;
    }

    public Class<? extends T> getKindClass() {
        return this.kindClass;
    }

    private void checkState(Key k) {
        if (k.kindClass == null && k.kind == null) {
            throw new IllegalStateException("Kind must be specified (or a class).");
        }
        if (k.id == null && k.idBytes == null) {
            throw new IllegalStateException("id must be specified");
        }
    }

    @Override
    public int compareTo(Key<?> other) {
        this.checkState(this);
        this.checkState(other);
        int cmp = 0;
        if (other.kindClass != null && this.kindClass != null && (cmp = this.kindClass.getName().compareTo(other.kindClass.getName())) != 0) {
            return cmp;
        }
        cmp = Key.compareNullable((Comparable)((Object)this.kind), (Comparable)((Object)other.kind));
        if (cmp != 0) {
            return cmp;
        }
        try {
            cmp = Key.compareNullable((Comparable)this.id, (Comparable)other.id);
            if (cmp != 0) {
                return cmp;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Key)) {
            return false;
        }
        return this.compareTo((Key)obj) == 0;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        StringBuilder bld = new StringBuilder("Key{");
        if (this.kind != null) {
            bld.append("kind=");
            bld.append(this.kind);
        } else {
            bld.append("kindClass=");
            bld.append(this.kindClass.getName());
        }
        bld.append(", id=");
        bld.append(this.id);
        bld.append("}");
        return bld.toString();
    }

    private static int compareNullable(Comparable o1, Comparable o2) {
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null && o2 != null) {
            return -1;
        }
        if (o1 != null && o2 == null) {
            return 1;
        }
        return o1.compareTo(o2);
    }
}

