/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.morphia.dao;

import com.google.code.morphia.Datastore;
import com.google.code.morphia.Key;
import com.google.code.morphia.query.Query;
import com.google.code.morphia.query.QueryResults;
import com.google.code.morphia.query.UpdateOperations;
import com.google.code.morphia.query.UpdateResults;
import com.mongodb.DBCollection;
import com.mongodb.WriteConcern;
import com.mongodb.WriteResult;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface DAO<T, K> {
    public Query<T> createQuery();

    public UpdateOperations<T> createUpdateOperations();

    public Class<T> getEntityClass();

    public Key<T> save(T var1);

    public Key<T> save(T var1, WriteConcern var2);

    public UpdateResults<T> updateFirst(Query<T> var1, UpdateOperations<T> var2);

    public UpdateResults<T> update(Query<T> var1, UpdateOperations<T> var2);

    public WriteResult delete(T var1);

    public WriteResult delete(T var1, WriteConcern var2);

    public WriteResult deleteById(K var1);

    public WriteResult deleteByQuery(Query<T> var1);

    public T get(K var1);

    public List<T> findIds(String var1, Object var2);

    public List<Key<T>> findIds();

    public List<Key<T>> findIds(Query<T> var1);

    public boolean exists(String var1, Object var2);

    public boolean exists(Query<T> var1);

    public long count();

    public long count(String var1, Object var2);

    public long count(Query<T> var1);

    public T findOne(String var1, Object var2);

    public T findOne(Query<T> var1);

    public QueryResults<T> find();

    public QueryResults<T> find(Query<T> var1);

    public void ensureIndexes();

    public DBCollection getCollection();

    public Datastore getDatastore();
}

