/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.morphia.mapping.validation.fieldrules;

import com.google.code.morphia.annotations.Serialized;
import com.google.code.morphia.mapping.MappedClass;
import com.google.code.morphia.mapping.MappedField;
import com.google.code.morphia.mapping.validation.ConstraintViolation;
import com.google.code.morphia.mapping.validation.fieldrules.FieldConstraint;
import com.google.code.morphia.utils.ReflectionUtils;
import java.io.Serializable;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapNotSerializable
extends FieldConstraint {
    @Override
    protected void check(MappedClass mc, MappedField mf, Set<ConstraintViolation> ve) {
        if (mf.isMap() && mf.hasAnnotation(Serialized.class)) {
            Class keyClass = ReflectionUtils.getParameterizedClass(mf.getField(), 0);
            Class valueClass = ReflectionUtils.getParameterizedClass(mf.getField(), 1);
            if (keyClass != null && !Serializable.class.isAssignableFrom(keyClass)) {
                ve.add(new ConstraintViolation(ConstraintViolation.Level.FATAL, mc, mf, this.getClass(), "Key class (" + keyClass.getName() + ") is not Serializable"));
            }
            if (valueClass != null && !Serializable.class.isAssignableFrom(keyClass)) {
                ve.add(new ConstraintViolation(ConstraintViolation.Level.FATAL, mc, mf, this.getClass(), "Value class (" + valueClass.getName() + ") is not Serializable"));
            }
        }
    }
}

