/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.morphia.mapping.validation;

import com.google.code.morphia.mapping.MappedClass;
import com.google.code.morphia.mapping.MappedField;
import com.google.code.morphia.mapping.validation.ClassConstraint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstraintViolation {
    private final MappedClass clazz;
    private MappedField field = null;
    private Class<? extends ClassConstraint> validator;
    private final String message;
    private final Level level;

    public ConstraintViolation(Level level, MappedClass clazz, MappedField field, Class<? extends ClassConstraint> validator, String message) {
        this(level, clazz, validator, message);
        this.field = field;
    }

    public ConstraintViolation(Level level, MappedClass clazz, Class<? extends ClassConstraint> validator, String message) {
        this.level = level;
        this.clazz = clazz;
        this.message = message;
        this.validator = validator;
    }

    public String render() {
        return String.format("%s complained about %s : %s", this.validator.getSimpleName(), this.getPrefix(), this.message);
    }

    public Level getLevel() {
        return this.level;
    }

    public String getPrefix() {
        String fn = this.field != null ? this.field.getJavaFieldName() : "";
        return this.clazz.getClazz().getName() + "." + fn;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Level {
        MINOR,
        INFO,
        WARNING,
        SEVERE,
        FATAL;

    }
}

