/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.morphia.converters;

import com.google.code.morphia.converters.SimpleValueConverter;
import com.google.code.morphia.converters.TypeConverter;
import com.google.code.morphia.mapping.MappedField;
import com.google.code.morphia.mapping.MappingException;

public class IntegerConverter
extends TypeConverter
implements SimpleValueConverter {
    public IntegerConverter() {
        super(Integer.TYPE, Integer.class);
    }

    public Object decode(Class targetClass, Object val, MappedField optionalExtraInfo) throws MappingException {
        if (val == null) {
            return null;
        }
        if (val instanceof Integer) {
            return val;
        }
        if (val instanceof Number) {
            return ((Number)val).intValue();
        }
        return Integer.parseInt(val.toString());
    }
}

