/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.morphia;

import com.google.code.morphia.AdvancedDatastore;
import com.google.code.morphia.AuthenticationException;
import com.google.code.morphia.Datastore;
import com.google.code.morphia.Key;
import com.google.code.morphia.MapreduceResults;
import com.google.code.morphia.MapreduceType;
import com.google.code.morphia.Morphia;
import com.google.code.morphia.VersionHelper;
import com.google.code.morphia.annotations.CappedAt;
import com.google.code.morphia.annotations.Entity;
import com.google.code.morphia.annotations.Index;
import com.google.code.morphia.annotations.Indexed;
import com.google.code.morphia.annotations.Indexes;
import com.google.code.morphia.annotations.PostPersist;
import com.google.code.morphia.annotations.Reference;
import com.google.code.morphia.annotations.Serialized;
import com.google.code.morphia.annotations.Version;
import com.google.code.morphia.logging.Logr;
import com.google.code.morphia.logging.MorphiaLoggerFactory;
import com.google.code.morphia.mapping.MappedClass;
import com.google.code.morphia.mapping.MappedField;
import com.google.code.morphia.mapping.Mapper;
import com.google.code.morphia.mapping.MappingException;
import com.google.code.morphia.mapping.cache.EntityCache;
import com.google.code.morphia.mapping.lazy.DatastoreHolder;
import com.google.code.morphia.mapping.lazy.proxy.ProxyHelper;
import com.google.code.morphia.query.Query;
import com.google.code.morphia.query.QueryException;
import com.google.code.morphia.query.QueryImpl;
import com.google.code.morphia.query.UpdateException;
import com.google.code.morphia.query.UpdateOperations;
import com.google.code.morphia.query.UpdateOpsImpl;
import com.google.code.morphia.query.UpdateResults;
import com.google.code.morphia.utils.Assert;
import com.google.code.morphia.utils.IndexDirection;
import com.google.code.morphia.utils.IndexFieldDef;
import com.mongodb.BasicDBObject;
import com.mongodb.BasicDBObjectBuilder;
import com.mongodb.CommandResult;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.DBRef;
import com.mongodb.Mongo;
import com.mongodb.MongoException;
import com.mongodb.WriteConcern;
import com.mongodb.WriteResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatastoreImpl
implements Datastore,
AdvancedDatastore {
    private static final Logr log = MorphiaLoggerFactory.get(DatastoreImpl.class);
    protected Mapper mapr;
    protected Mongo mongo;
    protected DB db;
    protected WriteConcern defConcern = WriteConcern.SAFE;

    public DatastoreImpl(Mapper mapr, Mongo mongo, String dbName) {
        this.mapr = mapr;
        this.mongo = mongo;
        this.db = mongo.getDB(dbName);
        DatastoreHolder.getInstance().set(this);
    }

    public DatastoreImpl(Morphia morphia, Mongo mongo) {
        this(morphia, mongo, null);
    }

    public DatastoreImpl(Morphia morphia, Mongo mongo, String dbName, String username, char[] password) {
        this(morphia.getMapper(), mongo, dbName);
        if (username != null && !this.db.authenticate(username, password)) {
            throw new AuthenticationException("User '" + username + "' cannot be authenticated with the given password for database '" + dbName + "'");
        }
    }

    public DatastoreImpl(Morphia morphia, Mongo mongo, String dbName) {
        this(morphia.getMapper(), mongo, dbName);
    }

    public DatastoreImpl copy(String db) {
        return new DatastoreImpl(this.mapr, this.mongo, db);
    }

    @Override
    public <T, V> DBRef createRef(Class<T> clazz, V id) {
        if (id == null) {
            throw new MappingException("Could not get id for " + clazz.getName());
        }
        return new DBRef(this.getDB(), this.getCollection((Class)clazz).getName(), id);
    }

    @Override
    public <T> DBRef createRef(T entity) {
        Object id = this.getId(entity = ProxyHelper.unwrap(entity));
        if (id == null) {
            throw new MappingException("Could not get id for " + entity.getClass().getName());
        }
        return this.createRef(entity.getClass(), id);
    }

    @Deprecated
    protected Object getId(Object entity) {
        return this.mapr.getId(entity);
    }

    @Override
    @Deprecated
    public <T> Key<T> getKey(T entity) {
        return this.mapr.getKey(entity);
    }

    protected <T, V> WriteResult delete(DBCollection dbColl, V id, WriteConcern wc) {
        WriteResult wr = wc == null ? dbColl.remove(BasicDBObjectBuilder.start().add("_id", id).get()) : dbColl.remove(BasicDBObjectBuilder.start().add("_id", id).get(), wc);
        this.throwOnError(wc, wr);
        return wr;
    }

    @Override
    public <T> WriteResult delete(String kind, T id) {
        DBCollection dbColl = this.getCollection(kind);
        return this.delete(dbColl, id, this.defConcern);
    }

    public <T, V> WriteResult delete(Class<T> clazz, V id, WriteConcern wc) {
        DBCollection dbColl = this.getCollection((Class)clazz);
        return this.delete(dbColl, id, wc);
    }

    @Override
    public <T, V> WriteResult delete(Class<T> clazz, V id) {
        return this.delete(clazz, id, this.getWriteConcern(clazz));
    }

    @Override
    public <T, V> WriteResult delete(Class<T> clazz, Iterable<V> ids) {
        Query<T> q = this.find(clazz).disableValidation().filter("_id in", ids);
        return this.delete(q);
    }

    @Override
    public <T> WriteResult delete(T entity) {
        return this.delete(entity, this.getWriteConcern(entity));
    }

    @Override
    public <T> WriteResult delete(T entity, WriteConcern wc) {
        if ((entity = ProxyHelper.unwrap(entity)) instanceof Class) {
            throw new MappingException("Did you mean to delete all documents? -- delete(ds.createQuery(???.class))");
        }
        try {
            Object id = this.getId(entity);
            return this.delete(entity.getClass(), id, wc);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <T> WriteResult delete(Query<T> query) {
        return this.delete(query, this.getWriteConcern(query.getEntityClass()));
    }

    @Override
    public <T> WriteResult delete(Query<T> query, WriteConcern wc) {
        QueryImpl q = (QueryImpl)query;
        DBCollection dbColl = q.getCollection();
        if (dbColl == null) {
            dbColl = this.getCollection(q.getEntityClass());
        }
        if (q.getSortObject() != null || q.getOffset() != 0 || q.getLimit() > 0) {
            throw new QueryException("Delete does not allow sort/offset/limit query options.");
        }
        WriteResult wr = q.getQueryObject() != null ? (wc == null ? dbColl.remove(q.getQueryObject()) : dbColl.remove(q.getQueryObject(), wc)) : (wc == null ? dbColl.remove((DBObject)new BasicDBObject()) : dbColl.remove((DBObject)new BasicDBObject(), wc));
        this.throwOnError(wc, wr);
        return wr;
    }

    @Override
    public <T> void ensureIndex(Class<T> type, String fields) {
        this.ensureIndex(type, null, fields, false, false);
    }

    @Override
    public <T> void ensureIndex(Class<T> clazz, String name, IndexFieldDef[] defs, boolean unique, boolean dropDupsOnCreate) {
        this.ensureIndex(clazz, name, defs, unique, dropDupsOnCreate, false);
    }

    @Override
    public <T> void ensureIndex(Class<T> clazz, String name, String fields, boolean unique, boolean dropDupsOnCreate) {
        this.ensureIndex(clazz, name, QueryImpl.parseFieldsString(fields, clazz, this.mapr, true), unique, dropDupsOnCreate, false, false);
    }

    public <T> void ensureIndex(Class<T> clazz, String name, String fields, boolean unique, boolean dropDupsOnCreate, boolean background) {
        this.ensureIndex(clazz, name, QueryImpl.parseFieldsString(fields, clazz, this.mapr, true), unique, dropDupsOnCreate, background, false);
    }

    protected <T> void ensureIndex(Class<T> clazz, String name, BasicDBObject fields, boolean unique, boolean dropDupsOnCreate, boolean background, boolean sparse) {
        BasicDBObjectBuilder keyOpts = new BasicDBObjectBuilder();
        if (name != null && name.length() > 0) {
            keyOpts.add("name", (Object)name);
        }
        if (unique) {
            keyOpts.add("unique", (Object)true);
            if (dropDupsOnCreate) {
                keyOpts.add("dropDups", (Object)true);
            }
        }
        if (background) {
            keyOpts.add("background", (Object)true);
        }
        if (sparse) {
            keyOpts.add("sparse", (Object)true);
        }
        DBCollection dbColl = this.getCollection((Class)clazz);
        BasicDBObject opts = (BasicDBObject)keyOpts.get();
        if (opts.isEmpty()) {
            log.debug("Ensuring index for " + dbColl.getName() + " with keys:" + fields);
            dbColl.ensureIndex((DBObject)fields);
        } else {
            log.debug("Ensuring index for " + dbColl.getName() + " with keys:" + fields + " and opts:" + opts);
            dbColl.ensureIndex((DBObject)fields, (DBObject)opts);
        }
        CommandResult cr = dbColl.getDB().getLastError();
        cr.throwOnError();
    }

    public void ensureIndex(Class clazz, String name, IndexFieldDef[] defs, boolean unique, boolean dropDupsOnCreate, boolean background) {
        BasicDBObjectBuilder keys = BasicDBObjectBuilder.start();
        for (IndexFieldDef def : defs) {
            String fieldName = def.getField();
            IndexDirection dir = def.getDirection();
            keys.add(fieldName, dir.toIndexValue());
        }
        this.ensureIndex(clazz, name, (BasicDBObject)keys.get(), unique, dropDupsOnCreate, background, false);
    }

    @Override
    public <T> void ensureIndex(Class<T> type, String name, IndexDirection dir) {
        this.ensureIndex(type, new IndexFieldDef(name, dir));
    }

    @Override
    public <T> void ensureIndex(Class<T> type, IndexFieldDef ... fields) {
        this.ensureIndex(type, null, fields, false, false);
    }

    public <T> void ensureIndex(Class<T> type, boolean background, IndexFieldDef ... fields) {
        this.ensureIndex(type, null, fields, false, false, background);
    }

    protected void ensureIndexes(MappedClass mc, boolean background) {
        this.ensureIndexes(mc, background, new ArrayList<MappedClass>(), new ArrayList<MappedField>());
    }

    protected void ensureIndexes(MappedClass mc, boolean background, ArrayList<MappedClass> parentMCs, ArrayList<MappedField> parentMFs) {
        if (parentMCs.contains(mc)) {
            return;
        }
        if (mc.getEmbeddedAnnotation() != null && (parentMCs == null || parentMCs.isEmpty())) {
            return;
        }
        Indexes idxs = (Indexes)mc.getAnnotation(Indexes.class);
        if (idxs != null && idxs.value() != null && idxs.value().length > 0) {
            for (Index index : idxs.value()) {
                BasicDBObject fields = QueryImpl.parseFieldsString(index.value(), mc.getClazz(), this.mapr, true);
                this.ensureIndex(mc.getClazz(), index.name(), fields, index.unique(), index.dropDups(), index.background() ? index.background() : background, index.sparse() ? index.sparse() : false);
            }
        }
        for (MappedField mf : mc.getPersistenceFields()) {
            if (mf.hasAnnotation(Indexed.class)) {
                Indexed index = mf.getAnnotation(Indexed.class);
                StringBuilder field = new StringBuilder();
                Class<?> indexedClass = (parentMCs.isEmpty() ? mc : parentMCs.get(0)).getClazz();
                if (!parentMCs.isEmpty()) {
                    for (MappedField pmf : parentMFs) {
                        field.append(pmf.getNameToStore()).append(".");
                    }
                }
                field.append(mf.getNameToStore());
                this.ensureIndex(indexedClass, index.name(), new BasicDBObject(field.toString(), index.value().toIndexValue()), index.unique(), index.dropDups(), index.background() ? index.background() : background, index.sparse() ? index.sparse() : false);
            }
            if (mf.isTypeMongoCompatible() || mf.hasAnnotation(Reference.class) || mf.hasAnnotation(Serialized.class)) continue;
            ArrayList newParentClasses = (ArrayList)parentMCs.clone();
            ArrayList newParents = (ArrayList)parentMFs.clone();
            newParentClasses.add(mc);
            newParents.add(mf);
            this.ensureIndexes(this.mapr.getMappedClass(mf.isSingleValue() ? mf.getType() : mf.getSubClass()), background, newParentClasses, newParents);
        }
    }

    @Override
    public <T> void ensureIndexes(Class<T> clazz) {
        this.ensureIndexes(clazz, false);
    }

    @Override
    public <T> void ensureIndexes(Class<T> clazz, boolean background) {
        MappedClass mc = this.mapr.getMappedClass(clazz);
        this.ensureIndexes(mc, background);
    }

    @Override
    public void ensureIndexes() {
        this.ensureIndexes(false);
    }

    @Override
    public void ensureIndexes(boolean background) {
        for (MappedClass mc : this.mapr.getMappedClasses()) {
            this.ensureIndexes(mc, background);
        }
    }

    @Override
    public void ensureCaps() {
        for (MappedClass mc : this.mapr.getMappedClasses()) {
            DB db;
            if (mc.getEntityAnnotation() == null || mc.getEntityAnnotation().cap().value() <= 0L) continue;
            CappedAt cap = mc.getEntityAnnotation().cap();
            String collName = this.mapr.getCollectionName(mc.getClazz());
            BasicDBObjectBuilder dbCapOpts = BasicDBObjectBuilder.start((String)"capped", (Object)true);
            if (cap.value() > 0L) {
                dbCapOpts.add("size", (Object)cap.value());
            }
            if (cap.count() > 0L) {
                dbCapOpts.add("max", (Object)cap.count());
            }
            if ((db = this.getDB()).getCollectionNames().contains(collName)) {
                CommandResult dbResult = db.command(BasicDBObjectBuilder.start((String)"collstats", (Object)collName).get());
                if (dbResult.containsField("capped")) {
                    log.warning("DBCollection already exists is cap'd already; doing nothing. " + dbResult);
                    continue;
                }
                log.warning("DBCollection already exists with same name(" + collName + ") and is not cap'd; not creating cap'd version!");
                continue;
            }
            this.getDB().createCollection(collName, dbCapOpts.get());
            log.debug("Created cap'd DBCollection (" + collName + ") with opts " + dbCapOpts);
        }
    }

    @Override
    public <T> Query<T> queryByExample(T ex) {
        return this.queryByExample(this.getCollection(ex), ex);
    }

    @Override
    public <T> Query<T> queryByExample(String kind, T ex) {
        return this.queryByExample(this.db.getCollection(kind), ex);
    }

    private <T> Query<T> queryByExample(DBCollection coll, T example) {
        return new QueryImpl(example.getClass(), coll, this, this.entityToDBObj(example, new HashMap<Object, DBObject>()));
    }

    @Override
    public <T> Query<T> createQuery(Class<T> clazz) {
        return new QueryImpl<T>(clazz, this.getCollection((Class)clazz), this);
    }

    @Override
    public <T> Query<T> createQuery(Class<T> kind, DBObject q) {
        return new QueryImpl<T>(kind, this.getCollection((Class)kind), this, q);
    }

    @Override
    public <T> Query<T> createQuery(String kind, Class<T> clazz, DBObject q) {
        return new QueryImpl<T>(clazz, this.db.getCollection(kind), this, q);
    }

    @Override
    public <T> Query<T> createQuery(String kind, Class<T> clazz) {
        return new QueryImpl<T>(clazz, this.db.getCollection(kind), this);
    }

    @Override
    public <T> Query<T> find(String kind, Class<T> clazz) {
        return new QueryImpl<T>(clazz, this.getCollection(kind), this);
    }

    @Override
    public <T> Query<T> find(Class<T> clazz) {
        return this.createQuery(clazz);
    }

    @Override
    public <T, V> Query<T> find(Class<T> clazz, String property, V value) {
        Query<T> query = this.createQuery(clazz);
        return query.filter(property, value);
    }

    @Override
    public <T, V> Query<T> find(String kind, Class<T> clazz, String property, V value, int offset, int size) {
        return this.find(kind, clazz, property, value, offset, size, true);
    }

    public <T, V> Query<T> find(String kind, Class<T> clazz, String property, V value, int offset, int size, boolean validate) {
        Query<T> query = this.find(kind, clazz);
        if (!validate) {
            query.disableValidation();
        }
        query.offset(offset);
        query.limit(size);
        return query.filter(property, value).enableValidation();
    }

    @Override
    public <T, V> Query<T> find(Class<T> clazz, String property, V value, int offset, int size) {
        Query<T> query = this.createQuery(clazz);
        query.offset(offset);
        query.limit(size);
        return query.filter(property, value);
    }

    @Override
    public <T> T get(Class<T> clazz, DBRef ref) {
        return (T)this.mapr.fromDBObject(clazz, ref.fetch(), this.createCache());
    }

    @Override
    public <T, V> Query<T> get(Class<T> clazz, Iterable<V> ids) {
        return this.find(clazz).disableValidation().filter("_id in", ids).enableValidation();
    }

    public <T> List<Key<T>> getKeysByRefs(List<DBRef> refs) {
        ArrayList tempKeys = new ArrayList(refs.size());
        HashMap<String, ArrayList<DBRef>> kindMap = new HashMap<String, ArrayList<DBRef>>();
        for (DBRef ref : refs) {
            if (kindMap.containsKey(ref.getRef())) {
                ((List)kindMap.get(ref.getRef())).add(ref);
                continue;
            }
            kindMap.put(ref.getRef(), new ArrayList<DBRef>(Collections.singletonList(ref)));
        }
        for (String kind : kindMap.keySet()) {
            ArrayList<Object> objIds = new ArrayList<Object>();
            List kindRefs = (List)kindMap.get(kind);
            for (DBRef key : kindRefs) {
                objIds.add(key.getId());
            }
            List kindResults = this.find(kind, null).disableValidation().filter("_id in", objIds).asKeyList();
            tempKeys.addAll(kindResults);
        }
        ArrayList<Key<T>> keys = new ArrayList<Key<T>>(refs.size());
        for (DBRef ref : refs) {
            Key testKey = this.mapr.refToKey(ref);
            if (!tempKeys.contains(testKey)) continue;
            keys.add(testKey);
        }
        return keys;
    }

    @Override
    public <T> List<T> getByKeys(Iterable<Key<T>> keys) {
        return this.getByKeys(null, keys);
    }

    @Override
    public <T> List<T> getByKeys(Class<T> clazz, Iterable<Key<T>> keys) {
        HashMap<String, ArrayList<Key<T>>> kindMap = new HashMap<String, ArrayList<Key<T>>>();
        ArrayList entities = new ArrayList();
        for (Key<T> key : keys) {
            this.mapr.updateKind(key);
            if (kindMap.containsKey(key.getKind())) {
                ((List)kindMap.get(key.getKind())).add(key);
                continue;
            }
            kindMap.put(key.getKind(), new ArrayList<Key<T>>(Collections.singletonList(key)));
        }
        for (String kind : kindMap.keySet()) {
            ArrayList<Object> objIds = new ArrayList<Object>();
            List kindKeys = (List)kindMap.get(kind);
            for (Key key : kindKeys) {
                objIds.add(key.getId());
            }
            List kindResults = this.find(kind, null).disableValidation().filter("_id in", objIds).asList();
            entities.addAll(kindResults);
        }
        return entities;
    }

    @Override
    public <T, V> T get(String kind, Class<T> clazz, V id) {
        List results = this.find(kind, clazz, "_id", id, 0, 1).asList();
        if (results == null || results.size() == 0) {
            return null;
        }
        return results.get(0);
    }

    @Override
    public <T, V> T get(Class<T> clazz, V id) {
        return this.find(this.getCollection((Class)clazz).getName(), clazz, "_id", id, 0, 1, false).get();
    }

    @Override
    public <T> T getByKey(Class<T> clazz, Key<T> key) {
        String keyKind;
        String kind = this.mapr.getCollectionName(clazz);
        if (!kind.equals(keyKind = this.mapr.updateKind(key))) {
            throw new RuntimeException("collection names don't match for key and class: " + kind + " != " + keyKind);
        }
        return this.get(clazz, key.getId());
    }

    @Override
    public <T> T get(T entity) {
        Object id = this.getId(entity = ProxyHelper.unwrap(entity));
        if (id == null) {
            throw new MappingException("Could not get id for " + entity.getClass().getName());
        }
        return (T)this.get(entity.getClass(), id);
    }

    @Override
    public Key<?> exists(Object entityOrKey) {
        Key<Object> key = this.getKey(entityOrKey = ProxyHelper.unwrap(entityOrKey));
        Object id = key.getId();
        if (id == null) {
            throw new MappingException("Could not get id for " + entityOrKey.getClass().getName());
        }
        String collName = key.getKind();
        if (collName == null) {
            collName = this.getCollection((Class)key.getKindClass()).getName();
        }
        return this.find(collName, key.getKindClass()).filter("_id", key.getId()).getKey();
    }

    public DBCollection getCollection(Class clazz) {
        String collName = this.mapr.getCollectionName(clazz);
        DBCollection dbC = this.getDB().getCollection(collName);
        return dbC;
    }

    public DBCollection getCollection(Object obj) {
        if (obj == null) {
            return null;
        }
        return this.getCollection((Class)obj.getClass());
    }

    protected DBCollection getCollection(String kind) {
        if (kind == null) {
            return null;
        }
        return this.getDB().getCollection(kind);
    }

    @Override
    public <T> long getCount(T entity) {
        entity = ProxyHelper.unwrap(entity);
        return this.getCollection(entity).count();
    }

    @Override
    public <T> long getCount(Class<T> clazz) {
        return this.getCollection((Class)clazz).count();
    }

    @Override
    public long getCount(String kind) {
        return this.getCollection(kind).count();
    }

    @Override
    public <T> long getCount(Query<T> query) {
        return query.countAll();
    }

    @Override
    public Mongo getMongo() {
        return this.mongo;
    }

    @Override
    public DB getDB() {
        return this.db;
    }

    public Mapper getMapper() {
        return this.mapr;
    }

    public <T> Iterable<Key<T>> insert(Iterable<T> entities) {
        T first = entities.iterator().next();
        return this.insert(entities, this.getWriteConcern(first));
    }

    @Override
    public <T> Iterable<Key<T>> insert(String kind, Iterable<T> entities, WriteConcern wc) {
        DBCollection dbColl = this.db.getCollection(kind);
        return this.insert(dbColl, entities, wc);
    }

    @Override
    public <T> Iterable<Key<T>> insert(String kind, Iterable<T> entities) {
        return this.insert(kind, entities, this.getWriteConcern(entities.iterator().next()));
    }

    @Override
    public <T> Iterable<Key<T>> insert(Iterable<T> entities, WriteConcern wc) {
        DBCollection dbColl = this.getCollection(entities.iterator().next());
        return this.insert(dbColl, entities, wc);
    }

    private <T> Iterable<Key<T>> insert(DBCollection dbColl, Iterable<T> entities, WriteConcern wc) {
        ArrayList<DBObject> ents = entities instanceof List ? new ArrayList<DBObject>(((List)entities).size()) : new ArrayList();
        LinkedHashMap<Object, DBObject> involvedObjects = new LinkedHashMap<Object, DBObject>();
        for (T ent : entities) {
            ents.add(this.entityToDBObj(ent, involvedObjects));
        }
        WriteResult wr = null;
        DBObject[] dbObjs = new DBObject[ents.size()];
        dbColl.insert(ents.toArray(dbObjs), wc);
        this.throwOnError(wc, wr);
        ArrayList<Key<T>> savedKeys = new ArrayList<Key<T>>();
        Iterator<T> entitiesIT = entities.iterator();
        Iterator dbObjsIT = ents.iterator();
        while (entitiesIT.hasNext()) {
            T entity = entitiesIT.next();
            DBObject dbObj = (DBObject)dbObjsIT.next();
            savedKeys.add(this.postSaveGetKey(entity, dbObj, dbColl, involvedObjects));
        }
        return savedKeys;
    }

    @Override
    public <T> Iterable<Key<T>> insert(T ... entities) {
        return this.insert((Iterable<T>)Arrays.asList(entities), this.getWriteConcern(entities[0]));
    }

    @Override
    public <T> Key<T> insert(T entity) {
        return this.insert(entity, this.getWriteConcern(entity));
    }

    @Override
    public <T> Key<T> insert(T entity, WriteConcern wc) {
        entity = ProxyHelper.unwrap(entity);
        DBCollection dbColl = this.getCollection(entity);
        return this.insert(dbColl, entity, wc);
    }

    @Override
    public <T> Key<T> insert(String kind, T entity) {
        entity = ProxyHelper.unwrap(entity);
        DBCollection dbColl = this.getCollection(kind);
        return this.insert(dbColl, entity, this.getWriteConcern(entity));
    }

    public <T> Key<T> insert(String kind, T entity, WriteConcern wc) {
        entity = ProxyHelper.unwrap(entity);
        DBCollection dbColl = this.getCollection(kind);
        return this.insert(dbColl, entity, wc);
    }

    protected <T> Key<T> insert(DBCollection dbColl, T entity, WriteConcern wc) {
        LinkedHashMap<Object, DBObject> involvedObjects = new LinkedHashMap<Object, DBObject>();
        DBObject dbObj = this.entityToDBObj(entity, involvedObjects);
        WriteResult wr = wc == null ? dbColl.insert(new DBObject[]{dbObj}) : dbColl.insert(dbObj, wc);
        this.throwOnError(wc, wr);
        return this.postSaveGetKey(entity, dbObj, dbColl, involvedObjects);
    }

    protected DBObject entityToDBObj(Object entity, Map<Object, DBObject> involvedObjects) {
        entity = ProxyHelper.unwrap(entity);
        DBObject dbObj = this.mapr.toDBObject(entity, involvedObjects);
        return dbObj;
    }

    protected <T> Key<T> postSaveGetKey(T entity, DBObject dbObj, DBCollection dbColl, Map<Object, DBObject> involvedObjects) {
        if (dbObj.get("_id") == null) {
            throw new MappingException("Missing _id after save!");
        }
        this.postSaveOperations(entity, dbObj, involvedObjects);
        Key key = new Key(dbColl.getName(), this.getId(entity));
        key.setKindClass(entity.getClass());
        return key;
    }

    @Override
    public <T> Iterable<Key<T>> save(Iterable<T> entities) {
        Object first = null;
        try {
            first = entities.iterator().next();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.save(entities, this.getWriteConcern(first));
    }

    @Override
    public <T> Iterable<Key<T>> save(Iterable<T> entities, WriteConcern wc) {
        ArrayList<Key<T>> savedKeys = new ArrayList<Key<T>>();
        for (T ent : entities) {
            savedKeys.add(this.save(ent, wc));
        }
        return savedKeys;
    }

    @Override
    public <T> Iterable<Key<T>> save(T ... entities) {
        ArrayList<Key<T>> savedKeys = new ArrayList<Key<T>>();
        for (T ent : entities) {
            savedKeys.add(this.save(ent));
        }
        return savedKeys;
    }

    protected <T> Key<T> save(DBCollection dbColl, T entity, WriteConcern wc) {
        MappedClass mc = this.mapr.getMappedClass(entity);
        WriteResult wr = null;
        LinkedHashMap<Object, DBObject> involvedObjects = new LinkedHashMap<Object, DBObject>();
        DBObject dbObj = this.entityToDBObj(entity, involvedObjects);
        wr = this.tryVersionedUpdate(dbColl, entity, dbObj, wc, this.db, mc);
        if (wr == null) {
            wr = wc == null ? dbColl.save(dbObj) : dbColl.save(dbObj, wc);
        }
        this.throwOnError(wc, wr);
        return this.postSaveGetKey(entity, dbObj, dbColl, involvedObjects);
    }

    protected <T> WriteResult tryVersionedUpdate(DBCollection dbColl, T entity, DBObject dbObj, WriteConcern wc, DB db, MappedClass mc) {
        WriteResult wr = null;
        if (mc.getFieldsAnnotatedWith(Version.class).isEmpty()) {
            return wr;
        }
        MappedField mfVersion = mc.getFieldsAnnotatedWith(Version.class).get(0);
        String versionKeyName = mfVersion.getNameToStore();
        Long oldVersion = (Long)mfVersion.getFieldValue(entity);
        long newVersion = VersionHelper.nextValue(oldVersion);
        dbObj.put(versionKeyName, (Object)newVersion);
        if (oldVersion != null && oldVersion > 0L) {
            Object idValue = dbObj.get("_id");
            UpdateResults<?> res = this.update(this.find(dbColl.getName(), entity.getClass()).filter("_id", idValue).filter(versionKeyName, oldVersion), dbObj, false, false, wc);
            wr = res.getWriteResult();
            if (res.getUpdatedCount() != 1) {
                throw new ConcurrentModificationException("Entity of class " + entity.getClass().getName() + " (id='" + idValue + "',version='" + oldVersion + "') was concurrently updated.");
            }
        } else {
            wr = wc == null ? dbColl.save(dbObj) : dbColl.save(dbObj, wc);
        }
        mfVersion.setFieldValue(entity, newVersion);
        return wr;
    }

    protected void throwOnError(WriteConcern wc, WriteResult wr) {
        CommandResult cr;
        if (wc == null && wr.getLastConcern() == null && (cr = wr.getLastError()) != null && cr.getErrorMessage() != null && cr.getErrorMessage().length() > 0) {
            cr.throwOnError();
        }
    }

    @Override
    public <T> Key<T> save(String kind, T entity) {
        entity = ProxyHelper.unwrap(entity);
        DBCollection dbColl = this.getCollection(kind);
        return this.save(dbColl, entity, this.getWriteConcern(entity));
    }

    @Override
    public <T> Key<T> save(T entity) {
        return this.save(entity, this.getWriteConcern(entity));
    }

    @Override
    public <T> Key<T> save(T entity, WriteConcern wc) {
        entity = ProxyHelper.unwrap(entity);
        DBCollection dbColl = this.getCollection(entity);
        return this.save(dbColl, entity, wc);
    }

    @Override
    public <T> UpdateOperations<T> createUpdateOperations(Class<T> clazz) {
        return new UpdateOpsImpl<T>(clazz, this.getMapper());
    }

    @Override
    public <T> UpdateOperations<T> createUpdateOperations(Class<T> kind, DBObject ops) {
        UpdateOpsImpl upOps = (UpdateOpsImpl)this.createUpdateOperations(kind);
        upOps.setOps(ops);
        return upOps;
    }

    @Override
    public <T> UpdateResults<T> update(Query<T> query, UpdateOperations<T> ops, boolean createIfMissing) {
        return this.update(query, ops, createIfMissing, this.getWriteConcern(query.getEntityClass()));
    }

    @Override
    public <T> UpdateResults<T> update(Query<T> query, UpdateOperations<T> ops, boolean createIfMissing, WriteConcern wc) {
        return this.update(query, ops, createIfMissing, true, wc);
    }

    @Override
    public <T> UpdateResults<T> update(T ent, UpdateOperations<T> ops) {
        if (ent instanceof Query) {
            return this.update((Query)ent, ops);
        }
        MappedClass mc = this.mapr.getMappedClass(ent);
        Query<?> q = this.createQuery(mc.getClazz());
        q.disableValidation().filter("_id", this.getId(ent));
        if (mc.getFieldsAnnotatedWith(Version.class).size() > 0) {
            MappedField versionMF = mc.getFieldsAnnotatedWith(Version.class).get(0);
            Long oldVer = (Long)versionMF.getFieldValue(ent);
            q.filter(versionMF.getNameToStore(), oldVer);
            ops.set(versionMF.getNameToStore(), VersionHelper.nextValue(oldVer));
        }
        return this.update(q, ops);
    }

    @Override
    public <T> UpdateResults<T> update(Key<T> key, UpdateOperations<T> ops) {
        Class<Object> clazz = key.getKindClass();
        if (clazz == null) {
            clazz = this.mapr.getClassFromKind(key.getKind());
        }
        return this.updateFirst(this.createQuery(clazz).disableValidation().filter("_id", key.getId()), ops);
    }

    @Override
    public <T> UpdateResults<T> update(Query<T> query, UpdateOperations<T> ops) {
        return this.update(query, ops, false, true);
    }

    @Override
    public <T> UpdateResults<T> updateFirst(Query<T> query, UpdateOperations<T> ops) {
        return this.update(query, ops, false, false);
    }

    @Override
    public <T> UpdateResults<T> updateFirst(Query<T> query, UpdateOperations<T> ops, boolean createIfMissing) {
        return this.update(query, ops, createIfMissing, this.getWriteConcern(query.getEntityClass()));
    }

    @Override
    public <T> UpdateResults<T> updateFirst(Query<T> query, UpdateOperations<T> ops, boolean createIfMissing, WriteConcern wc) {
        return this.update(query, ops, createIfMissing, false, wc);
    }

    @Override
    public <T> UpdateResults<T> updateFirst(Query<T> query, T entity, boolean createIfMissing) {
        LinkedHashMap<Object, DBObject> involvedObjects = new LinkedHashMap<Object, DBObject>();
        DBObject dbObj = this.mapr.toDBObject(entity, involvedObjects);
        UpdateResults<T> res = this.update(query, dbObj, createIfMissing, false, this.getWriteConcern(entity));
        CommandResult gle = res.getWriteResult().getCachedLastError();
        if (gle != null && res.getInsertedCount() > 0) {
            dbObj.put("_id", res.getNewId());
        }
        this.postSaveOperations(entity, dbObj, involvedObjects);
        return res;
    }

    @Override
    public <T> Key<T> merge(T entity) {
        return this.merge(entity, this.getWriteConcern(entity));
    }

    @Override
    public <T> Key<T> merge(T entity, WriteConcern wc) {
        LinkedHashMap<Object, DBObject> involvedObjects = new LinkedHashMap<Object, DBObject>();
        DBObject dbObj = this.mapr.toDBObject(entity, involvedObjects);
        Key<T> key = this.getKey(entity);
        Object id = this.getId(entity = ProxyHelper.unwrap(entity));
        if (id == null) {
            throw new MappingException("Could not get id for " + entity.getClass().getName());
        }
        Query<?> query = this.createQuery(entity.getClass()).filter("_id", id);
        dbObj.removeField("_id");
        UpdateResults<?> res = this.update(query, (DBObject)new BasicDBObject("$set", (Object)dbObj), false, false, wc);
        CommandResult gle = res.getWriteResult().getCachedLastError();
        if (gle != null && res.getUpdatedCount() == 0) {
            throw new UpdateException("Not updated: " + gle);
        }
        this.postSaveOperations(entity, dbObj, involvedObjects);
        return key;
    }

    private <T> void postSaveOperations(Object entity, DBObject dbObj, Map<Object, DBObject> involvedObjects) {
        this.mapr.updateKeyInfo(entity, dbObj, this.createCache());
        for (Map.Entry<Object, DBObject> e : involvedObjects.entrySet()) {
            Object ent = e.getKey();
            DBObject dbO = e.getValue();
            MappedClass mc = this.mapr.getMappedClass(ent);
            mc.callLifecycleMethods(PostPersist.class, ent, dbO, this.mapr);
        }
    }

    private <T> UpdateResults<T> update(Query<T> query, UpdateOperations ops, boolean createIfMissing, boolean multi, WriteConcern wc) {
        DBObject u = ((UpdateOpsImpl)ops).getOps();
        if (((UpdateOpsImpl)ops).isIsolated()) {
            Query<T> q = query.clone();
            q.disableValidation().filter("$atomic", true);
            return this.update(q, u, createIfMissing, multi, wc);
        }
        return this.update(query, u, createIfMissing, multi, wc);
    }

    private <T> UpdateResults<T> update(Query<T> query, UpdateOperations ops, boolean createIfMissing, boolean multi) {
        return this.update(query, ops, createIfMissing, multi, this.getWriteConcern(query.getEntityClass()));
    }

    private <T> UpdateResults<T> update(Query<T> query, DBObject u, boolean createIfMissing, boolean multi, WriteConcern wc) {
        QueryImpl qi = (QueryImpl)query;
        DBCollection dbColl = qi.getCollection();
        if (dbColl == null) {
            dbColl = this.getCollection(qi.getEntityClass());
        }
        if (qi.getSortObject() != null && qi.getSortObject().keySet() != null && !qi.getSortObject().keySet().isEmpty()) {
            throw new QueryException("sorting is not allowed for updates.");
        }
        if (qi.getOffset() > 0) {
            throw new QueryException("a query offset is not allowed for updates.");
        }
        if (qi.getLimit() > 0) {
            throw new QueryException("a query limit is not allowed for updates.");
        }
        DBObject q = qi.getQueryObject();
        if (q == null) {
            q = new BasicDBObject();
        }
        if (log.isTraceEnabled()) {
            log.trace("Executing update(" + dbColl.getName() + ") for query: " + q + ", ops: " + u + ", multi: " + multi + ", upsert: " + createIfMissing);
        }
        WriteResult wr = wc == null ? dbColl.update(q, u, createIfMissing, multi) : dbColl.update(q, u, createIfMissing, multi, wc);
        this.throwOnError(wc, wr);
        return new UpdateResults(wr);
    }

    @Override
    public <T> T findAndDelete(Query<T> query) {
        DBObject result;
        DBCollection dbColl = ((QueryImpl)query).getCollection();
        if (dbColl == null) {
            dbColl = this.getCollection(((QueryImpl)query).getEntityClass());
        }
        QueryImpl qi = (QueryImpl)query;
        EntityCache cache = this.createCache();
        if (log.isTraceEnabled()) {
            log.trace("Executing findAndModify(" + dbColl.getName() + ") with delete ...");
        }
        if ((result = dbColl.findAndModify(qi.getQueryObject(), qi.getFieldsObject(), qi.getSortObject(), true, null, false, false)) != null) {
            Object entity = this.mapr.fromDBObject(qi.getEntityClass(), result, cache);
            return (T)entity;
        }
        return null;
    }

    @Override
    public <T> T findAndModify(Query<T> q, UpdateOperations<T> ops) {
        return this.findAndModify(q, ops, false);
    }

    @Override
    public <T> T findAndModify(Query<T> query, UpdateOperations<T> ops, boolean oldVersion) {
        return this.findAndModify(query, ops, oldVersion, false);
    }

    @Override
    public <T> T findAndModify(Query<T> query, UpdateOperations<T> ops, boolean oldVersion, boolean createIfMissing) {
        DBObject res;
        QueryImpl qi;
        block5: {
            qi = (QueryImpl)query;
            DBCollection dbColl = qi.getCollection();
            if (dbColl == null) {
                dbColl = this.getCollection(qi.getEntityClass());
            }
            if (log.isTraceEnabled()) {
                log.info("Executing findAndModify(" + dbColl.getName() + ") with update ");
            }
            res = null;
            try {
                res = dbColl.findAndModify(qi.getQueryObject(), qi.getFieldsObject(), qi.getSortObject(), false, ((UpdateOpsImpl)ops).getOps(), !oldVersion, createIfMissing);
            }
            catch (MongoException e) {
                if (e.getMessage() != null && e.getMessage().contains("matching")) break block5;
                throw e;
            }
        }
        if (res == null) {
            return null;
        }
        return (T)this.mapr.fromDBObject(qi.getEntityClass(), res, this.createCache());
    }

    @Override
    public <T> MapreduceResults<T> mapReduce(MapreduceType type, Query query, String map, String reduce, String finalize, Map<String, Object> scopeFields, Class<T> outputType) {
        Assert.parametersNotNull("map", map);
        Assert.parameterNotEmpty(map, "map");
        Assert.parametersNotNull("reduce", reduce);
        Assert.parameterNotEmpty(reduce, "reduce");
        if (MapreduceType.INLINE.equals((Object)type)) {
            throw new IllegalArgumentException("Inline map/reduce is not supported.");
        }
        QueryImpl qi = (QueryImpl)query;
        DBCollection dbColl = qi.getCollection();
        if (dbColl == null) {
            dbColl = this.getCollection(qi.getEntityClass());
        }
        if (log.isTraceEnabled()) {
            log.info("Executing mapReduce(" + dbColl.getName() + ") with query(" + qi.toString() + ") map(" + map + ") reduce(" + reduce + ") finalize(" + finalize + ") scope(" + scopeFields + ")");
        }
        String outColl = this.mapr.getCollectionName(outputType);
        BasicDBObjectBuilder bldr = BasicDBObjectBuilder.start((String)"mapreduce", (Object)this.mapr.getCollectionName(qi.getEntityClass()));
        switch (type) {
            case REDUCE: {
                bldr.push("out").add("reduce", (Object)outColl).pop();
                break;
            }
            case MERGE: {
                bldr.push("out").add("merge", (Object)outColl).pop();
                break;
            }
            case INLINE: {
                bldr.push("out").add("inline", (Object)1).pop();
                break;
            }
            default: {
                bldr.add("out", (Object)outColl);
            }
        }
        if (qi.getOffset() != 0 || qi.getFieldsObject() != null) {
            throw new QueryException("mapReduce does not allow the offset/retrievedFields query options.");
        }
        if (qi.getQueryObject() != null) {
            bldr.add("query", (Object)qi.getQueryObject());
        }
        if (qi.getLimit() > 0) {
            bldr.add("limit", (Object)qi.getLimit());
        }
        if (qi.getSortObject() != null) {
            bldr.add("sort", (Object)qi.getSortObject());
        }
        bldr.add("map", (Object)map);
        bldr.add("reduce", (Object)reduce);
        if (finalize != null && finalize.length() > 0) {
            bldr.add("finalize", (Object)finalize);
        }
        if (scopeFields != null && scopeFields.size() > 0) {
            bldr.add("scope", this.mapr.toMongoObject(null, null, scopeFields));
        }
        DBObject dbObj = bldr.get();
        CommandResult cr = dbColl.getDB().command(dbObj);
        cr.throwOnError();
        MapreduceResults mrRes = (MapreduceResults)this.mapr.fromDBObject(MapreduceResults.class, (DBObject)cr, this.createCache());
        QueryImpl<T> baseQ = null;
        if (!MapreduceType.INLINE.equals((Object)type)) {
            baseQ = new QueryImpl<T>(outputType, this.db.getCollection(mrRes.getOutputCollectionName()), this);
        }
        mrRes.setBits(type, baseQ);
        return mrRes;
    }

    public static <T> List<DBRef> keysAsRefs(List<Key<T>> keys, Mapper mapr) {
        ArrayList<DBRef> refs = new ArrayList<DBRef>(keys.size());
        for (Key<T> key : keys) {
            refs.add(mapr.keyToRef(key));
        }
        return refs;
    }

    public static <T> List<Key<T>> refsToKeys(Mapper mapr, List<DBRef> refs, Class<T> c) {
        ArrayList<Key<T>> keys = new ArrayList<Key<T>>(refs.size());
        for (DBRef ref : refs) {
            keys.add(mapr.refToKey(ref));
        }
        return keys;
    }

    private EntityCache createCache() {
        return this.mapr.createEntityCache();
    }

    public WriteConcern getWriteConcern(Object clazzOrEntity) {
        Entity entityAnn;
        WriteConcern wc = this.defConcern;
        if (clazzOrEntity != null && (entityAnn = this.getMapper().getMappedClass(clazzOrEntity).getEntityAnnotation()) != null && !"".equals(entityAnn.concern())) {
            wc = WriteConcern.valueOf((String)entityAnn.concern());
        }
        return wc;
    }

    @Override
    public WriteConcern getDefaultWriteConcern() {
        return this.defConcern;
    }

    @Override
    public void setDefaultWriteConcern(WriteConcern wc) {
        this.defConcern = wc;
    }
}

