/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.morphia.mapping.cache;

import com.google.code.morphia.Key;
import com.google.code.morphia.logging.Logr;
import com.google.code.morphia.logging.MorphiaLoggerFactory;
import com.google.code.morphia.mapping.cache.EntityCache;
import com.google.code.morphia.mapping.cache.EntityCacheStatistics;
import com.google.code.morphia.mapping.lazy.LazyFeatureDependencies;
import com.google.code.morphia.mapping.lazy.proxy.ProxyHelper;
import java.util.HashMap;
import java.util.Map;
import relocated.morphia.org.apache.commons.collections.ReferenceMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultEntityCache
implements EntityCache {
    private static final Logr log = MorphiaLoggerFactory.get(DefaultEntityCache.class);
    private final Map<Key, Object> entityMap = new ReferenceMap(0, 2);
    private final Map<Key, Object> proxyMap = new ReferenceMap(2, 2);
    private final Map<Key, Boolean> existenceMap = new HashMap<Key, Boolean>();
    private final EntityCacheStatistics stats = new EntityCacheStatistics();

    @Override
    public Boolean exists(Key<?> k) {
        if (this.entityMap.containsKey(k)) {
            ++this.stats.hits;
            return true;
        }
        Boolean b = this.existenceMap.get(k);
        if (b == null) {
            ++this.stats.misses;
        } else {
            ++this.stats.hits;
        }
        return b;
    }

    @Override
    public void notifyExists(Key<?> k, boolean exists) {
        this.existenceMap.put(k, exists);
        ++this.stats.entities;
    }

    @Override
    public <T> T getEntity(Key<T> k) {
        Object o = this.entityMap.get(k);
        if (o == null) {
            Object proxy;
            if (LazyFeatureDependencies.testDependencyFullFilled() && (proxy = this.proxyMap.get(k)) != null) {
                ProxyHelper.isFetched(proxy);
                ++this.stats.hits;
                return (T)ProxyHelper.unwrap(proxy);
            }
            ++this.stats.misses;
        } else {
            ++this.stats.hits;
        }
        return (T)o;
    }

    @Override
    public <T> T getProxy(Key<T> k) {
        Object o = this.proxyMap.get(k);
        if (o == null) {
            ++this.stats.misses;
        } else {
            ++this.stats.hits;
        }
        return (T)o;
    }

    @Override
    public <T> void putProxy(Key<T> k, T t) {
        this.proxyMap.put(k, t);
        ++this.stats.entities;
    }

    @Override
    public <T> void putEntity(Key<T> k, T t) {
        this.notifyExists(k, true);
        this.entityMap.put(k, t);
    }

    @Override
    public void flush() {
        this.entityMap.clear();
        this.existenceMap.clear();
        this.proxyMap.clear();
        this.stats.reset();
    }

    @Override
    public EntityCacheStatistics stats() {
        return this.stats.copy();
    }
}

