/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.morphia.mapping.validation.fieldrules;

import com.google.code.morphia.annotations.Id;
import com.google.code.morphia.annotations.Reference;
import com.google.code.morphia.mapping.MappedClass;
import com.google.code.morphia.mapping.MappedField;
import com.google.code.morphia.mapping.MappingException;
import com.google.code.morphia.mapping.validation.ConstraintViolation;
import com.google.code.morphia.mapping.validation.fieldrules.FieldConstraint;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferenceToUnidentifiable
extends FieldConstraint {
    @Override
    protected void check(MappedClass mc, MappedField mf, Set<ConstraintViolation> ve) {
        if (mf.hasAnnotation(Reference.class)) {
            Class realType;
            Class clazz = realType = mf.isSingleValue() ? mf.getType() : mf.getSubClass();
            if (realType == null) {
                throw new MappingException("Type is null for this MappedField: " + mf);
            }
            if (!realType.isInterface() && mc.getMapper().getMappedClass(realType).getIdField() == null) {
                ve.add(new ConstraintViolation(ConstraintViolation.Level.FATAL, mc, mf, this.getClass(), mf.getFullName() + " is annotated as a @" + Reference.class.getSimpleName() + " but the " + mf.getType().getName() + " class is missing the @" + Id.class.getSimpleName() + " annotation"));
            }
        }
    }
}

