/*
 * Decompiled with CFR 0.152.
 */
package play.modules.morphia.utils;

import com.google.code.morphia.Datastore;
import com.google.code.morphia.query.Query;
import com.google.code.morphia.query.UpdateOperations;
import com.google.code.morphia.utils.LongIdEntity;
import org.bson.types.ObjectId;
import play.modules.morphia.Model;
import play.modules.morphia.MorphiaPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdGenerator {
    public static Datastore ds() {
        return MorphiaPlugin.ds();
    }

    public static Object generateId(Model entity) {
        MorphiaPlugin.IdType t = MorphiaPlugin.getIdType();
        switch (t) {
            case Long: {
                return IdGenerator.generateLongId(entity);
            }
            case ObjectId: {
                return IdGenerator.generateObjectIdId(entity);
            }
        }
        throw new IllegalStateException("Shouldn't be here. Probably user entity does not override generateId() method for user annotated Id field.");
    }

    public static <T extends Model> Long generateLongId(T entity) {
        return IdGenerator.generateLongId(entity.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends Model> Long generateLongId(Class<T> clazz) {
        Class<T> clazz2 = clazz;
        synchronized (clazz2) {
            String collName = IdGenerator.ds().getCollection(clazz).getName();
            Query q = IdGenerator.ds().find(LongIdEntity.StoredId.class, "_id", (Object)collName);
            UpdateOperations uOps = IdGenerator.ds().createUpdateOperations(LongIdEntity.StoredId.class).inc("value");
            LongIdEntity.StoredId newId = (LongIdEntity.StoredId)IdGenerator.ds().findAndModify(q, uOps);
            if (newId == null) {
                newId = new LongIdEntity.StoredId(collName);
                IdGenerator.ds().save((Object)newId);
            }
            return newId.getValue();
        }
    }

    public static <T extends Model> ObjectId generateObjectIdId(T entity) {
        return new ObjectId();
    }

    public static <T extends Model> ObjectId generateObjectIdId(Class<T> clazz) {
        return new ObjectId();
    }

    public static String getIdTypeName() {
        MorphiaPlugin.IdType t = MorphiaPlugin.getIdType();
        switch (t) {
            case Long: {
                return Long.class.getName();
            }
            case ObjectId: {
                return ObjectId.class.getName();
            }
        }
        throw new IllegalStateException("How can i get here???");
    }

    public static Object processId(Object id) {
        MorphiaPlugin.IdType t = MorphiaPlugin.getIdType();
        switch (t) {
            case Long: {
                return IdGenerator.processLongId(id);
            }
            case ObjectId: {
                return IdGenerator.processObjectId(id);
            }
        }
        return id;
    }

    public static ObjectId processObjectId(Object id) {
        if (id instanceof ObjectId) {
            return (ObjectId)id;
        }
        return null == id ? null : new ObjectId(id.toString());
    }

    public static Long processLongId(Object id) {
        if (id instanceof Long) {
            return (Long)id;
        }
        return null == id ? null : Long.valueOf(Long.parseLong(id.toString()));
    }
}

