/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.morphia.logging.jdk;

import com.google.code.morphia.logging.Logr;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JDKLogger
implements Logr {
    private static final long serialVersionUID = 1L;
    private final Logger logger;

    public JDKLogger(Class c) {
        this.logger = Logger.getLogger(c.getName());
    }

    public boolean isTraceEnabled() {
        return this.logger.isLoggable(Level.FINER);
    }

    public void trace(String msg) {
        this.log(Level.FINER, msg, new Object[0]);
    }

    public void trace(String format, Object ... arg) {
        this.log(Level.FINER, format, arg);
    }

    public void trace(String msg, Throwable t) {
        this.log(Level.FINER, msg, t);
    }

    public boolean isDebugEnabled() {
        return this.logger.isLoggable(Level.FINE);
    }

    public void debug(String msg) {
        this.log(Level.FINE, msg, new Object[0]);
    }

    public void debug(String format, Object ... arg) {
        this.log(Level.FINE, format, arg);
    }

    public void debug(String msg, Throwable t) {
        this.log(Level.FINE, msg, t);
    }

    public boolean isInfoEnabled() {
        return this.logger.isLoggable(Level.INFO);
    }

    public void info(String msg) {
        this.log(Level.INFO, msg, new Object[0]);
    }

    public void info(String format, Object ... arg) {
        this.log(Level.INFO, format, arg);
    }

    public void info(String msg, Throwable t) {
        this.log(Level.INFO, msg, t);
    }

    public boolean isWarningEnabled() {
        return this.logger.isLoggable(Level.WARNING);
    }

    public void warning(String msg) {
        this.log(Level.WARNING, msg, new Object[0]);
    }

    public void warning(String format, Object ... arg) {
        this.log(Level.WARNING, format, arg);
    }

    public void warning(String msg, Throwable t) {
        this.log(Level.WARNING, msg, t);
    }

    public boolean isErrorEnabled() {
        return this.logger.isLoggable(Level.SEVERE);
    }

    public void error(String msg) {
        this.log(Level.SEVERE, msg, new Object[0]);
    }

    public void error(String format, Object ... arg) {
        this.log(Level.SEVERE, format, arg);
    }

    public void error(String msg, Throwable t) {
        this.log(Level.SEVERE, msg, t);
    }

    protected void log(Level l, String m, Throwable t) {
        String[] callerInfo = this.getCaller(new Throwable());
        this.logger.logp(l, callerInfo[0], callerInfo[1], m, t);
    }

    protected void log(Level l, String f, Object ... a) {
        String[] callerInfo = this.getCaller(new Throwable());
        this.logger.logp(l, callerInfo[0], callerInfo[1], f, a);
    }

    protected String[] getCaller(Throwable t) {
        StackTraceElement ste;
        String fc;
        int i;
        StackTraceElement[] stack = new Throwable().getStackTrace();
        String loggerClassname = this.getClass().getName();
        String callerName = "";
        String callerMethod = "";
        for (i = 0; i < stack.length && !(fc = (ste = stack[i]).getClassName()).equals(loggerClassname); ++i) {
        }
        ++i;
        while (i < stack.length) {
            ste = stack[i];
            fc = ste.getClassName();
            if (!fc.equals(loggerClassname)) {
                callerMethod = ste.getMethodName();
                callerName = fc;
                return new String[]{callerName, callerMethod};
            }
            ++i;
        }
        return new String[]{"", ""};
    }
}

