/*
 * Decompiled with CFR 0.152.
 */
package play.test;

import com.google.code.morphia.Datastore;
import java.util.ArrayList;
import java.util.List;
import play.Play;
import play.classloading.ApplicationClasses;
import play.modules.morphia.Model;
import play.modules.morphia.MorphiaPlugin;
import play.test.Fixtures;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MorphiaFixtures
extends Fixtures {
    private static Datastore ds() {
        return MorphiaPlugin.ds();
    }

    public static void deleteDatabase() {
        idCache.clear();
        Datastore ds = MorphiaFixtures.ds();
        for (Class clz : Play.classloader.getAssignableClasses(Model.class)) {
            ds.getCollection(clz).drop();
        }
    }

    public static void delete(Class<? extends Model> ... types) {
        idCache.clear();
        for (Class<? extends Model> type : types) {
            MorphiaFixtures.ds().getCollection(type).drop();
        }
    }

    public static void delete(List<Class<? extends Model>> classes) {
        idCache.clear();
        for (Class<? extends Model> type : classes) {
            MorphiaFixtures.ds().getCollection(type).drop();
        }
    }

    public static void deleteAllModels() {
        ArrayList<Class<? extends Model>> mongoClasses = new ArrayList<Class<? extends Model>>();
        for (ApplicationClasses.ApplicationClass c : Play.classes.getAssignableClasses(play.db.Model.class)) {
            Class jc = c.javaClass;
            mongoClasses.add(jc);
        }
        MorphiaFixtures.delete(mongoClasses);
    }
}

