/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.morphia.logging.jdk;

import com.google.code.morphia.logging.jdk.FastestJDKLogger;
import java.util.logging.Level;

public class FasterJDKLogger
extends FastestJDKLogger {
    private static final long serialVersionUID = 1L;

    public FasterJDKLogger(Class c) {
        super(c);
    }

    private String getCallingMethod() {
        StackTraceElement[] stack = new Throwable().getStackTrace();
        for (int j = 0; j < stack.length; ++j) {
            StackTraceElement ste = stack[j];
            if (!this.className.equals(ste.getClassName())) continue;
            return ste.getMethodName();
        }
        return "<method name unknown due to misused non-private logger>";
    }

    protected void log(Level l, String m, Throwable t) {
        if (this.logger.isLoggable(l)) {
            this.logger.logp(l, this.className, this.getCallingMethod(), m, t);
        }
    }

    protected void log(Level l, String f, Object ... a) {
        if (this.logger.isLoggable(l)) {
            this.logger.logp(l, this.className, this.getCallingMethod(), f, a);
        }
    }
}

