/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.morphia.mapping;

import com.google.code.morphia.EntityInterceptor;
import com.google.code.morphia.annotations.Converters;
import com.google.code.morphia.annotations.Embedded;
import com.google.code.morphia.annotations.Entity;
import com.google.code.morphia.annotations.EntityListeners;
import com.google.code.morphia.annotations.Id;
import com.google.code.morphia.annotations.Indexes;
import com.google.code.morphia.annotations.Polymorphic;
import com.google.code.morphia.annotations.PostLoad;
import com.google.code.morphia.annotations.PostPersist;
import com.google.code.morphia.annotations.PreLoad;
import com.google.code.morphia.annotations.PrePersist;
import com.google.code.morphia.annotations.PreSave;
import com.google.code.morphia.annotations.Property;
import com.google.code.morphia.annotations.Reference;
import com.google.code.morphia.annotations.Serialized;
import com.google.code.morphia.annotations.Transient;
import com.google.code.morphia.annotations.Version;
import com.google.code.morphia.logging.Logr;
import com.google.code.morphia.logging.MorphiaLoggerFactory;
import com.google.code.morphia.mapping.MappedField;
import com.google.code.morphia.mapping.Mapper;
import com.google.code.morphia.mapping.validation.MappingValidator;
import com.google.code.morphia.utils.ReflectionUtils;
import com.mongodb.DBObject;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappedClass {
    private static final Logr log = MorphiaLoggerFactory.get(MappedClass.class);
    private Field idField;
    private Entity entityAn;
    private Embedded embeddedAn;
    public static List<Class<? extends Annotation>> interestingAnnotations = new ArrayList<Class>(Arrays.asList(Embedded.class, Entity.class, Polymorphic.class, EntityListeners.class, Version.class, Converters.class, Indexes.class));
    private static Class<? extends Annotation>[] lifecycleAnnotations = new Class[]{PrePersist.class, PreSave.class, PostPersist.class, PreLoad.class, PostLoad.class};
    private Map<Class<? extends Annotation>, Annotation> foundAnnotations = new HashMap<Class<? extends Annotation>, Annotation>();
    private Map<Class<? extends Annotation>, List<ClassMethodPair>> lifecycleMethods = new HashMap<Class<? extends Annotation>, List<ClassMethodPair>>();
    private String collName;
    private List<MappedField> persistenceFields = new ArrayList<MappedField>();
    private Class<?> clazz;
    Mapper mapr;

    public MappedClass(Class<?> clazz, Mapper mapr) {
        this.mapr = mapr;
        this.clazz = clazz;
        if (log.isTraceEnabled()) {
            log.trace("Creating MappedClass for " + clazz);
        }
        this.discover();
        if (log.isDebugEnabled()) {
            log.debug("MappedClass done: " + this.toString());
        }
    }

    protected void discover() {
        for (Class<? extends Annotation> c : interestingAnnotations) {
            this.addAnnotation(c);
        }
        ArrayList lifecycleClasses = new ArrayList();
        lifecycleClasses.add(this.clazz);
        EntityListeners entityLisAnn = (EntityListeners)this.foundAnnotations.get(EntityListeners.class);
        if (entityLisAnn != null && entityLisAnn.value() != null && entityLisAnn.value().length != 0) {
            for (Class<?> clazz : entityLisAnn.value()) {
                lifecycleClasses.add(clazz);
            }
        }
        for (Class clazz : lifecycleClasses) {
            for (Method method : ReflectionUtils.getDeclaredAndInheritedMethods(clazz)) {
                for (Class<? extends Annotation> c : lifecycleAnnotations) {
                    if (!method.isAnnotationPresent(c)) continue;
                    this.addLifecycleEventMethod(c, method, clazz.equals(this.clazz) ? null : clazz);
                }
            }
        }
        this.embeddedAn = (Embedded)this.foundAnnotations.get(Embedded.class);
        this.entityAn = (Entity)this.foundAnnotations.get(Entity.class);
        this.collName = this.entityAn == null || this.entityAn.value().equals(".") ? this.clazz.getSimpleName() : this.entityAn.value();
        for (AnnotatedElement annotatedElement : ReflectionUtils.getDeclaredAndInheritedFields(this.clazz, true)) {
            ((Field)annotatedElement).setAccessible(true);
            int fieldMods = ((Field)annotatedElement).getModifiers();
            if (((AccessibleObject)annotatedElement).isAnnotationPresent(Transient.class) || ((Field)annotatedElement).isSynthetic() && (fieldMods & 0x80) == 128 || this.mapr.getOptions().actLikeSerializer && (fieldMods & 0x80) == 128 || this.mapr.getOptions().ignoreFinals && (fieldMods & 0x10) == 16) continue;
            if (((AccessibleObject)annotatedElement).isAnnotationPresent(Id.class)) {
                this.idField = annotatedElement;
                MappedField mf = new MappedField(this.idField, this.clazz);
                this.persistenceFields.add(mf);
                continue;
            }
            if (((AccessibleObject)annotatedElement).isAnnotationPresent(Property.class) || ((AccessibleObject)annotatedElement).isAnnotationPresent(Reference.class) || ((AccessibleObject)annotatedElement).isAnnotationPresent(Embedded.class) || ((AccessibleObject)annotatedElement).isAnnotationPresent(Serialized.class) || MappedClass.isSupportedType(((Field)annotatedElement).getType()) || ReflectionUtils.implementsInterface(((Field)annotatedElement).getType(), Serializable.class)) {
                this.persistenceFields.add(new MappedField((Field)annotatedElement, this.clazz));
                continue;
            }
            if (this.mapr.getOptions().defaultMapper != null) {
                this.persistenceFields.add(new MappedField((Field)annotatedElement, this.clazz));
                continue;
            }
            if (!log.isWarningEnabled()) continue;
            log.warning("Ignoring (will not persist) field: " + this.clazz.getName() + "." + ((Field)annotatedElement).getName() + " [type:" + ((Field)annotatedElement).getType().getName() + "]");
        }
    }

    private void addLifecycleEventMethod(Class<? extends Annotation> lceClazz, Method m, Class<?> clazz) {
        ClassMethodPair cm = new ClassMethodPair(clazz, m);
        if (this.lifecycleMethods.containsKey(lceClazz)) {
            this.lifecycleMethods.get(lceClazz).add(cm);
        } else {
            ArrayList<ClassMethodPair> methods = new ArrayList<ClassMethodPair>();
            methods.add(cm);
            this.lifecycleMethods.put(lceClazz, methods);
        }
    }

    public List<ClassMethodPair> getLifecycleMethods(Class<Annotation> clazz) {
        return this.lifecycleMethods.get(clazz);
    }

    private void addAnnotation(Class<? extends Annotation> c) {
        Annotation ann = ReflectionUtils.getAnnotation(this.getClazz(), c);
        if (ann != null) {
            this.foundAnnotations.put(c, ann);
        }
    }

    public String toString() {
        return "MappedClass - kind:" + this.getCollectionName() + " for " + this.getClazz().getName() + " fields:" + this.persistenceFields;
    }

    public List<MappedField> getFieldsAnnotatedWith(Class<? extends Annotation> clazz) {
        ArrayList<MappedField> results = new ArrayList<MappedField>();
        for (MappedField mf : this.persistenceFields) {
            if (!mf.foundAnnotations.containsKey(clazz)) continue;
            results.add(mf);
        }
        return results;
    }

    public MappedField getMappedField(String storedName) {
        for (MappedField mf : this.persistenceFields) {
            for (String n : mf.getLoadNames()) {
                if (!storedName.equals(n)) continue;
                return mf;
            }
        }
        return null;
    }

    public boolean containsJavaFieldName(String name) {
        return this.getMappedField(name) != null;
    }

    public MappedField getMappedFieldByJavaField(String name) {
        for (MappedField mf : this.persistenceFields) {
            if (!name.equals(mf.getJavaFieldName())) continue;
            return mf;
        }
        return null;
    }

    public static boolean isSupportedType(Class<?> clazz) {
        if (ReflectionUtils.isPropertyType(clazz)) {
            return true;
        }
        if (clazz.isArray() || Map.class.isAssignableFrom(clazz) || Iterable.class.isAssignableFrom(clazz)) {
            Class subType = null;
            subType = clazz.isArray() ? clazz.getComponentType() : ReflectionUtils.getParameterizedClass(clazz);
            return subType == null || subType == Object.class || ReflectionUtils.isPropertyType(subType);
        }
        return false;
    }

    public void validate() {
        new MappingValidator().validate(this);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Class) {
            return this.equals((Class)obj);
        }
        if (obj instanceof MappedClass) {
            return this.equals((MappedClass)obj);
        }
        return false;
    }

    public boolean equals(MappedClass clazz) {
        return this.getClazz().equals(clazz.getClazz());
    }

    public boolean equals(Class<?> clazz) {
        return this.getClazz().equals(clazz);
    }

    public DBObject callLifecycleMethods(Class<? extends Annotation> event, Object entity, DBObject dbObj, Mapper mapr) {
        List<ClassMethodPair> methodPairs = this.getLifecycleMethods(event);
        DBObject retDbObj = dbObj;
        try {
            Object tempObj = null;
            if (methodPairs != null) {
                HashMap<Class, Object> toCall = new HashMap<Class, Object>((int)((double)methodPairs.size() * 1.3));
                for (ClassMethodPair cm : methodPairs) {
                    toCall.put(cm.clazz, null);
                }
                for (Class c : toCall.keySet()) {
                    if (c == null) continue;
                    toCall.put(c, this.getOrCreateInstance(c));
                }
                for (ClassMethodPair cm : methodPairs) {
                    Method method = cm.method;
                    Class<?> type = cm.clazz;
                    Object inst = toCall.get(type);
                    method.setAccessible(true);
                    if (log.isDebugEnabled()) {
                        log.debug("Calling lifecycle method(@" + event.getSimpleName() + " " + method + ") on " + inst + "");
                    }
                    tempObj = inst == null ? (method.getParameterTypes().length == 0 ? method.invoke(entity, new Object[0]) : method.invoke(entity, retDbObj)) : (method.getParameterTypes().length == 0 ? method.invoke(inst, new Object[0]) : (method.getParameterTypes().length == 1 ? method.invoke(inst, entity) : method.invoke(inst, entity, retDbObj)));
                    if (tempObj == null) continue;
                    retDbObj = (DBObject)tempObj;
                }
            }
            this.callGlobalInterceptors(event, entity, dbObj, mapr, mapr.getInterceptors());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        return retDbObj;
    }

    private Object getOrCreateInstance(Class<?> clazz) {
        if (this.mapr.instanceCache.containsKey(clazz)) {
            return this.mapr.instanceCache.get(clazz);
        }
        Object o = this.mapr.getOptions().objectFactory.createInstance(clazz);
        Object nullO = this.mapr.instanceCache.put(clazz, o);
        if (nullO != null && log.isErrorEnabled()) {
            log.error("Race-condition, created duplicate class: " + clazz);
        }
        return o;
    }

    private void callGlobalInterceptors(Class<? extends Annotation> event, Object entity, DBObject dbObj, Mapper mapr, Collection<EntityInterceptor> interceptors) {
        for (EntityInterceptor ei : interceptors) {
            if (log.isDebugEnabled()) {
                log.debug("Calling interceptor method " + event.getSimpleName() + " on " + ei);
            }
            if (event.equals(PreLoad.class)) {
                ei.preLoad(entity, dbObj, mapr);
                continue;
            }
            if (event.equals(PostLoad.class)) {
                ei.postLoad(entity, dbObj, mapr);
                continue;
            }
            if (event.equals(PrePersist.class)) {
                ei.prePersist(entity, dbObj, mapr);
                continue;
            }
            if (event.equals(PreSave.class)) {
                ei.preSave(entity, dbObj, mapr);
                continue;
            }
            if (!event.equals(PostPersist.class)) continue;
            ei.postPersist(entity, dbObj, mapr);
        }
    }

    public Field getIdField() {
        return this.idField;
    }

    public Entity getEntityAnnotation() {
        return this.entityAn;
    }

    public Embedded getEmbeddedAnnotation() {
        return this.embeddedAn;
    }

    public Map<Class<? extends Annotation>, Annotation> getReleventAnnotations() {
        return this.foundAnnotations;
    }

    public Annotation getAnnotation(Class<? extends Annotation> clazz) {
        return this.foundAnnotations.get(clazz);
    }

    public List<MappedField> getPersistenceFields() {
        return this.persistenceFields;
    }

    public String getCollectionName() {
        return this.collName;
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    public Mapper getMapper() {
        return this.mapr;
    }

    public MappedField getMappedIdField() {
        return this.getFieldsAnnotatedWith(Id.class).get(0);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ClassMethodPair {
        Class<?> clazz;
        Method method;

        public ClassMethodPair(Class<?> c, Method m) {
            this.clazz = c;
            this.method = m;
        }
    }
}

