/*
 * Decompiled with CFR 0.152.
 */
package play.test;

import com.google.code.morphia.Datastore;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.scanner.ScannerException;
import play.Play;
import play.classloading.ApplicationClasses;
import play.data.binding.Binder;
import play.data.binding.ParamNode;
import play.data.binding.RootParamNode;
import play.db.Model;
import play.exceptions.YAMLException;
import play.modules.morphia.MorphiaPlugin;
import play.templates.TemplateLoader;
import play.test.Fixtures;
import play.vfs.VirtualFile;

public class MorphiaFixtures
extends Fixtures {
    private static Datastore ds() {
        return MorphiaPlugin.ds();
    }

    public static void deleteDatabase() {
        idCache.clear();
        Datastore ds = MorphiaFixtures.ds();
        for (Class clz : Play.classloader.getAssignableClasses(play.modules.morphia.Model.class)) {
            ds.getCollection(clz).drop();
        }
    }

    public static void delete(Class<? extends play.modules.morphia.Model> ... types) {
        idCache.clear();
        for (Class<? extends play.modules.morphia.Model> type : types) {
            MorphiaFixtures.ds().getCollection(type).drop();
        }
    }

    public static void delete(List<Class<? extends play.modules.morphia.Model>> classes) {
        idCache.clear();
        for (Class<? extends play.modules.morphia.Model> type : classes) {
            MorphiaFixtures.ds().getCollection(type).drop();
        }
    }

    public static void deleteAllModels() {
        ArrayList<Class<? extends play.modules.morphia.Model>> mongoClasses = new ArrayList<Class<? extends play.modules.morphia.Model>>();
        for (ApplicationClasses.ApplicationClass c : Play.classes.getAssignableClasses(Model.class)) {
            Class jc = c.javaClass;
            mongoClasses.add(jc);
        }
        MorphiaFixtures.delete(mongoClasses);
    }

    public static void loadModels(String name) {
        VirtualFile yamlFile = null;
        try {
            VirtualFile vf;
            Iterator i$ = Play.javaPath.iterator();
            while (i$.hasNext() && ((yamlFile = (vf = (VirtualFile)i$.next()).child(name)) == null || !yamlFile.exists())) {
            }
            if (yamlFile == null) {
                throw new RuntimeException("Cannot load fixture " + name + ", the file was not found");
            }
            Yaml yaml = new Yaml();
            String renderedYaml = TemplateLoader.load(yamlFile).render();
            Object o = yaml.load(renderedYaml);
            if (o instanceof LinkedHashMap) {
                LinkedHashMap objects = (LinkedHashMap)o;
                for (Object key : objects.keySet()) {
                    Matcher matcher = keyPattern.matcher(key.toString().trim());
                    if (!matcher.matches()) continue;
                    String type = matcher.group(1);
                    String id = matcher.group(2);
                    if (!type.startsWith("models.")) {
                        type = "models." + type;
                    }
                    if (idCache.containsKey(type + "-" + id)) {
                        throw new RuntimeException("Cannot load fixture " + name + ", duplicate id '" + id + "' for type " + type);
                    }
                    Map entityValues = (Map)objects.get(key);
                    Map fields = MorphiaFixtures.serialize((Map)entityValues, (String)"object");
                    Class cType = Play.classloader.loadClass(type);
                    Map<String, String[]> resolvedFields = MorphiaFixtures.resolveDependencies(cType, fields);
                    RootParamNode rootParamNode = ParamNode.convert(resolvedFields);
                    if (Model.class.isAssignableFrom(cType)) {
                        Model model = (Model)Binder.bind((RootParamNode)rootParamNode, (String)"object", (Class)cType, (Type)cType, null);
                        for (Field f : model.getClass().getFields()) {
                            if (f.getType().isAssignableFrom(Map.class)) {
                                f.set(model, ((Map)objects.get(key)).get(f.getName()));
                            }
                            if (!f.getType().equals(byte[].class)) continue;
                            f.set(model, ((Map)objects.get(key)).get(f.getName()));
                        }
                        model._save();
                        Class tType = cType;
                        while (!tType.equals(Object.class)) {
                            idCache.put(tType.getName() + "-" + id, Model.Manager.factoryFor((Class)cType).keyValue(model));
                            tType = tType.getSuperclass();
                        }
                        continue;
                    }
                    idCache.put(cType.getName() + "-" + id, Binder.bind((RootParamNode)rootParamNode, (String)"object", (Class)cType, (Type)cType, null));
                }
            }
            Play.pluginCollection.afterFixtureLoad();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Class " + e.getMessage() + " was not found", e);
        }
        catch (ScannerException e) {
            throw new YAMLException(e, yamlFile);
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new RuntimeException("Cannot load fixture " + name + ": " + e.getMessage(), e);
        }
    }

    static Map<String, String[]> resolveDependencies(Class<Model> type, Map<String, String[]> yml) {
        HashSet fields = new HashSet();
        HashMap<String, String[]> resolvedYml = new HashMap<String, String[]>();
        resolvedYml.putAll(yml);
        Class<Model> clazz = type;
        while (!clazz.equals(Object.class)) {
            Collections.addAll(fields, clazz.getDeclaredFields());
            clazz = clazz.getSuperclass();
        }
        List modelFields = Model.Manager.factoryFor(type).listProperties();
        for (Model.Property field : modelFields) {
            if (!field.isRelation) continue;
            String[] ids = (String[])resolvedYml.get("object." + field.name);
            if (ids != null) {
                String[] resolvedIds = new String[ids.length];
                for (int i = 0; i < ids.length; ++i) {
                    String id = field.relationType.getName() + "-" + ids[i];
                    if (!idCache.containsKey(id)) {
                        throw new RuntimeException("No previous reference found for object of type " + field.name + " with key " + ids[i]);
                    }
                    resolvedIds[i] = idCache.get(id).toString();
                }
                if (Model.class.isAssignableFrom(field.relationType)) {
                    resolvedYml.put("object." + field.name + "." + Model.Manager.factoryFor((Class)field.relationType).keyName(), resolvedIds);
                } else {
                    String id = field.relationType.getName() + "-" + ids[0];
                    Object o = idCache.get(id);
                    if (o.getClass().isArray()) {
                        for (Object a : (Object[])o) {
                            for (Field f : field.relationType.getDeclaredFields()) {
                                try {
                                    resolvedYml.put("object." + field.name + "." + f.getName(), new String[]{f.get(a).toString()});
                                }
                                catch (Exception e) {
                                    // empty catch block
                                }
                            }
                        }
                    } else {
                        for (Field f : field.relationType.getDeclaredFields()) {
                            try {
                                resolvedYml.put("object." + field.name + "." + f.getName(), new String[]{f.get(o).toString()});
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                        }
                    }
                }
            }
            resolvedYml.remove("object." + field.name);
        }
        return resolvedYml;
    }
}

