/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.morphia.utils;

import com.google.code.morphia.utils.Assert;
import com.google.code.morphia.utils.ReflectionUtils;
import java.lang.reflect.Field;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldName {
    public static String of(String name) {
        return FieldName.of(FieldName.callingClass(), name);
    }

    public static String of(Class<?> clazz, String name) {
        Assert.parameterNotNull(clazz, "clazz");
        Assert.parameterNotNull(name, "name");
        if (FieldName.hasField(clazz, name)) {
            return name;
        }
        throw new FieldNameNotFoundException("Field called '" + name + "' on class '" + clazz + "' was not found.");
    }

    private static boolean hasField(Class<?> clazz, String name) {
        Field[] fa;
        for (Field field : fa = ReflectionUtils.getDeclaredAndInheritedFields(clazz, true)) {
            if (!name.equals(field.getName())) continue;
            return true;
        }
        return false;
    }

    private static Class<?> callingClass() throws IllegalStateException {
        return FieldName.callingClass(FieldName.class);
    }

    private static Class<?> callingClass(Class<?> ... classesToExclude) {
        StackTraceElement[] stackTrace = new Exception().getStackTrace();
        for (int i = 0; i < stackTrace.length; ++i) {
            StackTraceElement e = stackTrace[i];
            String c = e.getClassName();
            boolean exclude = false;
            for (Class<?> ec : classesToExclude) {
                exclude |= c.equals(ec.getName());
            }
            if (exclude) continue;
            return FieldName.forName(c);
        }
        throw new IllegalStateException();
    }

    private static Class<?> forName(String c) {
        try {
            return Class.forName(c);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Error when getting class for name '" + c + "'");
        }
    }

    public static class FieldNameNotFoundException
    extends RuntimeException {
        public FieldNameNotFoundException(String msg) {
            super(msg);
        }
    }
}

