/*
 * Decompiled with CFR 0.152.
 */
package play.modules.morphia;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.gridfs.GridFSDBFile;
import com.mongodb.gridfs.GridFSInputFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.activation.MimetypesFileTypeMap;
import org.apache.commons.lang.RandomStringUtils;
import org.bson.types.ObjectId;
import play.Logger;
import play.db.Model;
import play.modules.morphia.MorphiaPlugin;

public class Blob
implements Model.BinaryField {
    private GridFSDBFile file;

    public Blob() {
    }

    public Blob(InputStream is, String type) {
        this();
        this.set(is, type);
    }

    public Blob(File inputFile, String type) {
        this();
        try {
            this.set(inputFile, type);
        }
        catch (IOException e) {
            Logger.debug((String)"File not found: %s (%s)", (Object[])new Object[]{inputFile.getAbsolutePath(), e.getMessage()});
        }
    }

    public Blob(File inputFile) {
        this(inputFile, new MimetypesFileTypeMap().getContentType(inputFile));
    }

    public Blob(String id) {
        BasicDBObject queryObj = new BasicDBObject("name", (Object)id);
        this.file = MorphiaPlugin.gridFs().findOne((DBObject)queryObj);
    }

    public void delete() {
        if (null == this.file) {
            return;
        }
        MorphiaPlugin.gridFs().remove((ObjectId)this.file.getId());
    }

    public static GridFSDBFile findFile(String name) {
        BasicDBObject queryObj = new BasicDBObject("name", (Object)name);
        return MorphiaPlugin.gridFs().findOne((DBObject)queryObj);
    }

    public InputStream get() {
        return this.file != null ? this.file.getInputStream() : null;
    }

    public void set(File file, String type) throws IOException {
        if (!file.exists()) {
            Logger.warn((String)"File not exists: %s", (Object[])new Object[]{file});
            return;
        }
        GridFSInputFile inputFile = MorphiaPlugin.gridFs().createFile(file);
        inputFile.setContentType(type);
        inputFile.save();
        this.file = MorphiaPlugin.gridFs().findOne(new ObjectId(inputFile.getId().toString()));
    }

    public void set(InputStream is, String type) {
        String rand = RandomStringUtils.randomAlphanumeric((int)10);
        GridFSInputFile inputFile = MorphiaPlugin.gridFs().createFile(is);
        inputFile.setContentType(type);
        inputFile.put("name", (Object)rand);
        inputFile.save();
        this.file = MorphiaPlugin.gridFs().findOne(new ObjectId(inputFile.getId().toString()));
    }

    public long length() {
        return this.file == null ? 0L : this.file.getLength();
    }

    public String type() {
        return this.file.getContentType();
    }

    public boolean exists() {
        return this.file != null && this.file.getId() != null;
    }

    public static void delete(String name) {
        MorphiaPlugin.gridFs().remove((DBObject)new BasicDBObject("name", (Object)name));
    }

    public GridFSDBFile getGridFSFile() {
        return this.file;
    }

    public String toString() {
        if (this.file != null) {
            return this.file.getId() + "/" + this.file.getFilename();
        }
        return null;
    }
}

