/*
 * Decompiled with CFR 0.152.
 */
package play.modules.morphia;

import com.google.code.morphia.Datastore;
import com.google.code.morphia.Morphia;
import com.google.code.morphia.annotations.Embedded;
import com.google.code.morphia.annotations.Entity;
import com.google.code.morphia.annotations.Id;
import com.google.code.morphia.annotations.Reference;
import com.google.code.morphia.annotations.Transient;
import com.google.code.morphia.mapping.validation.ConstraintViolationException;
import com.google.code.morphia.query.Criteria;
import com.google.code.morphia.query.Query;
import com.mongodb.DB;
import com.mongodb.Mongo;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.bson.types.ObjectId;
import play.Logger;
import play.Play;
import play.PlayPlugin;
import play.classloading.ApplicationClasses;
import play.data.binding.Binder;
import play.db.Model;
import play.exceptions.UnexpectedException;
import play.modules.morphia.Model;
import play.modules.morphia.MorphiaEnhancer;

public class MorphiaPlugin
extends PlayPlugin {
    public static final String VERSION = "1.2beta";
    public static final String PREFIX = "morphia.db.";
    private MorphiaEnhancer e_ = new MorphiaEnhancer();
    private static Morphia m_ = null;
    private static Datastore ds_ = null;
    private static boolean configured_ = false;
    private static IdType idType_ = IdType.ObjectId;

    public static boolean configured() {
        return configured_;
    }

    public static IdType getIdType() {
        return idType_;
    }

    public static Datastore ds() {
        return ds_;
    }

    public void enhance(ApplicationClasses.ApplicationClass applicationClass) throws Exception {
        this.onConfigurationRead();
        this.e_.enhanceThisClass(applicationClass);
    }

    public void onConfigurationRead() {
        String password;
        String username;
        Mongo m;
        if (configured_) {
            return;
        }
        Logger.debug((String)"Morphia> reading configuration", (Object[])new Object[0]);
        Properties c = Play.configuration;
        String host = c.getProperty("morphia.db.host", "localhost");
        String port = c.getProperty("morphia.db.port", "27017");
        try {
            m = new Mongo(host, Integer.parseInt(port));
            Logger.trace((String)"MongoDB host: %1$s", (Object[])new Object[]{host});
            Logger.trace((String)"MongoDB port: %1$s", (Object[])new Object[]{port});
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e.getMessage());
        }
        String dbName = c.getProperty("morphia.db.name");
        DB db = m.getDB(dbName);
        if (c.containsKey("morphia.db.username") && c.containsKey("morphia.db.password") && !db.authenticate(username = c.getProperty("morphia.db.username"), (password = c.getProperty("morphia.db.password")).toCharArray())) {
            throw new RuntimeException("MongoDB authentication failed: " + dbName);
        }
        if (c.containsKey("morphia.id.type")) {
            Logger.debug((String)"Morphia> reading id type...", (Object[])new Object[0]);
            String s = c.getProperty("morphia.id.type");
            try {
                idType_ = IdType.valueOf(s);
                Logger.debug((String)"ID Type set to : %1$s", (Object[])new Object[]{idType_.name()});
                if (VERSION.equals(VERSION) && idType_ == IdType.Long) {
                    Logger.warn((String)"Caution: Using reference in your model entities might cause problem when you ID type set to Long. Check http://groups.google.com/group/morphia/browse_thread/thread/bdd51121c2845973", (Object[])new Object[0]);
                }
            }
            catch (Exception e) {
                Logger.warn((Throwable)e, (String)"Error configure morphia id type: %1$s. Id type set to default: ObjectId.", (Object[])new Object[]{s});
            }
        }
        m_ = new Morphia();
        ds_ = m_.createDatastore(m, dbName);
        configured_ = true;
    }

    public void afterApplicationStart() {
        ArrayList<Class> pending = new ArrayList<Class>();
        HashMap<Class, Integer> retries = new HashMap<Class, Integer>();
        List cs = Play.classes.all();
        for (ApplicationClasses.ApplicationClass c : cs) {
            Class clz = c.javaClass;
            if (!clz.isAnnotationPresent(Entity.class)) continue;
            try {
                Logger.trace((String)">> mapping class: %1$s", (Object[])new Object[]{clz.getName()});
                m_.map(clz);
            }
            catch (ConstraintViolationException e) {
                Logger.error((Throwable)e, (String)"error mapping class [%1$s]", (Object[])new Object[]{clz});
                pending.add(clz);
                retries.put(clz, 1);
            }
        }
        while (!pending.isEmpty()) {
            for (Class clz : pending) {
                try {
                    Logger.trace((String)">> mapping class: ", (Object[])new Object[]{clz.getName()});
                    m_.map(clz);
                    pending.remove(clz);
                }
                catch (ConstraintViolationException e) {
                    Logger.error((Throwable)e, (String)"error mapping class [%1$s]", (Object[])new Object[]{clz});
                    int retry = (Integer)retries.get(clz);
                    if (retry > 2) {
                        throw new RuntimeException("too many errories mapping Morphia Entity classes");
                    }
                    retries.put(clz, (Integer)retries.get(clz) + 1);
                }
            }
        }
        Logger.info((String)"Morphia[%1$s] initialized", (Object[])new Object[]{VERSION});
    }

    public Object bind(String name, Class clazz, Type type, Annotation[] annotations, Map<String, String[]> params) {
        if (Model.class.isAssignableFrom(clazz)) {
            String keyName = this.modelFactory(clazz).keyName();
            String idKey = name + "." + keyName;
            if (params.containsKey(idKey) && params.get(idKey).length > 0 && params.get(idKey)[0] != null && params.get(idKey)[0].trim().length() > 0) {
                String id = params.get(idKey)[0];
                try {
                    Object o = MorphiaPlugin.ds().createQuery(clazz).filter(keyName, (Object)new ObjectId(id)).get();
                    return Model.edit(o, name, params, annotations);
                }
                catch (Exception e) {
                    return null;
                }
            }
            return Model.create(clazz, name, params, annotations);
        }
        return super.bind(name, clazz, type, annotations, params);
    }

    public Object bind(String name, Object o, Map<String, String[]> params) {
        if (o instanceof Model) {
            return Model.edit(o, name, params, null);
        }
        return null;
    }

    public Model.Factory modelFactory(Class<? extends play.db.Model> modelClass) {
        if (Model.class.isAssignableFrom(modelClass) && modelClass.isAnnotationPresent(Entity.class)) {
            return MorphiaModelLoader.getFactory(modelClass);
        }
        return null;
    }

    public static class MorphiaModelLoader
    implements Model.Factory {
        private static Map<Class<? extends Model>, Model.Factory> m_ = new HashMap<Class<? extends Model>, Model.Factory>();
        private Class<? extends Model> clazz;

        private MorphiaModelLoader(Class<? extends Model> clazz) {
            this.clazz = clazz;
            m_.put(clazz, this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static Model.Factory getFactory(Class<? extends Model> clazz) {
            Map<Class<? extends Model>, Model.Factory> map = m_;
            synchronized (map) {
                Model.Factory f = m_.get(clazz);
                if (null == f) {
                    f = new MorphiaModelLoader(clazz);
                }
                return f;
            }
        }

        public Model findById(Object id) {
            if (id == null) {
                return null;
            }
            try {
                return (Model)MorphiaPlugin.ds().find(this.clazz, this.keyName(), Binder.directBind((String)id.toString(), (Class)Model.Manager.factoryFor(this.clazz).keyType())).get();
            }
            catch (Exception e) {
                return null;
            }
        }

        public List<play.db.Model> fetch(int offset, int size, String orderBy, String order, List<String> searchFields, String keywords, String where) {
            if (orderBy == null) {
                orderBy = this.keyName();
            }
            if ("DESC".equalsIgnoreCase(order)) {
                orderBy = null == orderBy ? null : "-" + orderBy;
            }
            Query q = MorphiaPlugin.ds().createQuery(this.clazz).offset(offset).limit(size);
            if (null != orderBy) {
                q = q.order(orderBy);
            }
            if (keywords != null && !keywords.equals("")) {
                ArrayList<Object> cl = new ArrayList<Object>();
                for (String f : this.fillSearchFieldsIfEmpty_(searchFields)) {
                    cl.add(q.criteria(f).contains(keywords));
                }
                q.or(cl.toArray(new Criteria[0]));
            }
            if (null != where && !"".equals(where)) {
                Logger.warn((String)"'where' condition not supported yet, it will be discarded: %1$s", (Object[])new Object[]{where});
            }
            ArrayList<play.db.Model> l = new ArrayList<play.db.Model>();
            l.addAll(q.asList());
            return l;
        }

        private List<String> fillSearchFieldsIfEmpty_(List<String> l) {
            if (l == null) {
                l = new ArrayList<String>();
            }
            if (l.isEmpty()) {
                for (Model.Property property : this.listProperties()) {
                    if (!property.isSearchable) continue;
                    l.add(property.name);
                }
            }
            return l;
        }

        public Long count(List<String> searchFields, String keywords, String where) {
            Query q = MorphiaPlugin.ds().createQuery(this.clazz);
            if (keywords != null && !keywords.equals("")) {
                ArrayList<Object> cl = new ArrayList<Object>();
                for (String f : this.fillSearchFieldsIfEmpty_(searchFields)) {
                    cl.add(q.criteria(f).contains(keywords));
                }
                q.or(cl.toArray(new Criteria[0]));
            }
            if (null != where || !"".equals(where)) {
                Logger.warn((String)"'where' condition not supported yet, it will be discarded: %1$s", (Object[])new Object[]{where});
            }
            return q.countAll();
        }

        public void deleteAll() {
            MorphiaPlugin.ds().delete(MorphiaPlugin.ds().createQuery(this.clazz));
        }

        public List<Model.Property> listProperties() {
            ArrayList<Model.Property> properties = new ArrayList<Model.Property>();
            HashSet fields = new HashSet();
            Class<? extends Model> tclazz = this.clazz;
            while (!tclazz.equals(Object.class)) {
                Collections.addAll(fields, tclazz.getDeclaredFields());
                tclazz = tclazz.getSuperclass();
            }
            for (Field f : fields) {
                Model.Property mp;
                if (Modifier.isTransient(f.getModifiers()) || Modifier.isStatic(f.getModifiers()) || f.isAnnotationPresent(Transient.class) || (mp = this.buildProperty(f)) == null) continue;
                properties.add(mp);
            }
            return properties;
        }

        public String keyName() {
            Field f = this.keyField();
            return f == null ? null : f.getName();
        }

        public Class<?> keyType() {
            return this.keyField().getType();
        }

        public Object keyValue(play.db.Model m) {
            Field k = this.keyField();
            try {
                return null != k ? k.get(m) : null;
            }
            catch (Exception ex) {
                throw new UnexpectedException((Throwable)ex);
            }
        }

        Field keyField() {
            Class<? extends Model> c = this.clazz;
            try {
                while (!c.equals(Object.class)) {
                    for (Field field : c.getDeclaredFields()) {
                        if (!field.isAnnotationPresent(Id.class)) continue;
                        field.setAccessible(true);
                        return field;
                    }
                    c = c.getSuperclass();
                }
            }
            catch (Exception e) {
                throw new UnexpectedException("Error while determining the object @Id for an object of type " + c);
            }
            return null;
        }

        Model.Property buildProperty(final Field field) {
            Model.Property modelProperty = new Model.Property();
            modelProperty.type = field.getType();
            modelProperty.field = field;
            if (Model.class.isAssignableFrom(field.getType())) {
                if (field.isAnnotationPresent(Embedded.class)) {
                    modelProperty.isRelation = true;
                    modelProperty.relationType = field.getType();
                    modelProperty.choices = new Model.Choices(){

                        public List<Object> list() {
                            return Collections.EMPTY_LIST;
                        }
                    };
                }
                if (field.isAnnotationPresent(Reference.class)) {
                    modelProperty.isRelation = true;
                    modelProperty.relationType = field.getType();
                    modelProperty.choices = new Model.Choices(){

                        public List<Object> list() {
                            return MorphiaPlugin.ds().createQuery(field.getType()).asList();
                        }
                    };
                }
            }
            if (Collection.class.isAssignableFrom(field.getType())) {
                Class fieldType = (Class)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0];
                if (field.isAnnotationPresent(Reference.class)) {
                    modelProperty.isRelation = true;
                    modelProperty.isMultiple = true;
                    modelProperty.relationType = fieldType;
                    modelProperty.choices = new Model.Choices(){

                        public List<Object> list() {
                            return MorphiaPlugin.ds().createQuery(field.getType()).asList();
                        }
                    };
                }
            }
            modelProperty.name = field.getName();
            if (field.getType().equals(String.class)) {
                modelProperty.isSearchable = true;
            }
            return modelProperty;
        }
    }

    public static enum IdType {
        Long,
        ObjectId;

    }
}

