/*
 * Decompiled with CFR 0.152.
 */
package play.modules.morphia.utils;

import java.util.Arrays;
import java.util.BitSet;

public class Serializer
extends com.google.code.morphia.mapping.Serializer {
    private static final int[] BIT_MASK_ = new int[]{128, 64, 32, 16, 8, 4, 2, 1};

    public static BitSet asBitSet(byte[] ba) {
        if (ba == null) {
            return new BitSet(0);
        }
        BitSet bs = new BitSet(ba.length * 8);
        for (int i = 0; i < bs.size(); ++i) {
            if (!Serializer.isBitOn_(i, ba)) continue;
            bs.set(i);
        }
        return bs;
    }

    public static byte[] fromBitSet(BitSet bs) {
        if (null == bs) {
            return new byte[0];
        }
        int sz = bs.size();
        if (sz == 0) {
            return new byte[0];
        }
        int hiBit = -1;
        for (int i = 0; i < sz; ++i) {
            if (!bs.get(i)) continue;
            hiBit = i;
        }
        int n = (hiBit + 8) / 8;
        byte[] bytes = new byte[n];
        if (n == 0) {
            return bytes;
        }
        Arrays.fill(bytes, (byte)0);
        for (int i = 0; i < n * 8; ++i) {
            if (!bs.get(i)) continue;
            Serializer.setBit_(i, bytes);
        }
        return bytes;
    }

    private static void setBit_(int bit, byte[] bytes) {
        int size;
        int n = size = bytes == null ? 0 : bytes.length * 8;
        if (bit >= size) {
            throw new ArrayIndexOutOfBoundsException("Byte array too small");
        }
        int n2 = bit / 8;
        bytes[n2] = (byte)(bytes[n2] | BIT_MASK_[bit % 8]);
    }

    private static boolean isBitOn_(int bit, byte[] bytes) {
        int size;
        int n = size = bytes == null ? 0 : bytes.length * 8;
        if (bit >= size) {
            return false;
        }
        return (bytes[bit / 8] & BIT_MASK_[bit % 8]) != 0;
    }
}

