/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.morphia.logging;

import com.google.code.morphia.logging.Logr;
import com.google.code.morphia.logging.LogrFactory;
import com.google.code.morphia.logging.jdk.JDKLoggerFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MorphiaLogrFactory {
    private static LogrFactory loggerFactory = null;
    private static List<String> factories = new ArrayList<String>(Arrays.asList(JDKLoggerFactory.class.getName(), "com.google.code.morphia.logging.slf4j.SLF4JLogrImplFactory"));

    private static synchronized void init() {
        if (loggerFactory == null) {
            MorphiaLogrFactory.chooseLoggerFactory();
        }
    }

    private static void chooseLoggerFactory() {
        Collections.reverse(factories);
        for (String f : factories) {
            loggerFactory = MorphiaLogrFactory.newInstance(f);
            if (loggerFactory == null) continue;
            loggerFactory.get(MorphiaLogrFactory.class).info("LoggerImplFactory set to " + loggerFactory.getClass().getName());
            return;
        }
        throw new IllegalStateException("Cannot instanciate any MorphiaLoggerFactory");
    }

    private static LogrFactory newInstance(String f) {
        try {
            Class<?> c = Class.forName(f);
            return (LogrFactory)c.newInstance();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static final Logr get(Class<?> c) {
        MorphiaLogrFactory.init();
        return loggerFactory.get(c);
    }

    public static void registerLogger(Class<? extends LogrFactory> factoryClass) {
        if (loggerFactory != null) {
            throw new IllegalStateException("LoggerImplFactory must be registered before logging is initialized.");
        }
        factories.add(0, factoryClass.getName());
    }
}

