/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.morphia.query;

import com.google.code.morphia.logging.Logr;
import com.google.code.morphia.logging.MorphiaLoggerFactory;
import com.google.code.morphia.query.CriteriaContainerImpl;
import com.google.code.morphia.query.FieldCriteria;
import com.google.code.morphia.query.FieldEnd;
import com.google.code.morphia.query.FilterOperator;
import com.google.code.morphia.query.GeoFieldCriteria;
import com.google.code.morphia.query.QueryImpl;
import com.google.code.morphia.utils.Assert;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldEndImpl<T extends CriteriaContainerImpl>
implements FieldEnd<T> {
    private static final Logr log = MorphiaLoggerFactory.get(FieldEndImpl.class);
    private QueryImpl<?> query;
    private String field;
    private T target;
    private boolean validateName;

    public FieldEndImpl(QueryImpl<?> query, String field, T target, boolean validateName) {
        this.query = query;
        this.field = field;
        this.target = target;
        this.validateName = validateName;
    }

    private T addCrit(FilterOperator op, Object val) {
        ((CriteriaContainerImpl)this.target).add(new FieldCriteria(this.query, this.field, op, val, this.validateName, this.query.isValidatingTypes()));
        return this.target;
    }

    private T addGeoCrit(FilterOperator op, Object val, Map<String, Object> opts) {
        ((CriteriaContainerImpl)this.target).add(new GeoFieldCriteria(this.query, this.field, op, val, this.validateName, false, opts));
        return this.target;
    }

    @Override
    public T startsWith(String prefix) {
        Assert.parametersNotNull("val", prefix);
        return this.addCrit(FilterOperator.EQUAL, Pattern.compile("^" + prefix));
    }

    @Override
    public T startsWithIgnoreCase(String prefix) {
        Assert.parametersNotNull("val", prefix);
        return this.addCrit(FilterOperator.EQUAL, Pattern.compile("^" + prefix, 2));
    }

    @Override
    public T endsWith(String suffix) {
        Assert.parametersNotNull("val", suffix);
        return this.addCrit(FilterOperator.EQUAL, Pattern.compile(suffix + "$"));
    }

    @Override
    public T endsWithIgnoreCase(String suffix) {
        Assert.parametersNotNull("val", suffix);
        return this.addCrit(FilterOperator.EQUAL, Pattern.compile(suffix + "$", 2));
    }

    @Override
    public T contains(String string) {
        Assert.parametersNotNull("val", string);
        return this.addCrit(FilterOperator.EQUAL, Pattern.compile(string));
    }

    @Override
    public T containsIgnoreCase(String string) {
        Assert.parametersNotNull("val", string);
        return this.addCrit(FilterOperator.EQUAL, Pattern.compile(string, 2));
    }

    @Override
    public T exists() {
        return this.addCrit(FilterOperator.EXISTS, true);
    }

    @Override
    public T doesNotExist() {
        return this.addCrit(FilterOperator.EXISTS, false);
    }

    @Override
    public T equal(Object val) {
        return this.addCrit(FilterOperator.EQUAL, val);
    }

    @Override
    public T greaterThan(Object val) {
        Assert.parametersNotNull("val", val);
        return this.addCrit(FilterOperator.GREATER_THAN, val);
    }

    @Override
    public T greaterThanOrEq(Object val) {
        Assert.parametersNotNull("val", val);
        return this.addCrit(FilterOperator.GREATER_THAN_OR_EQUAL, val);
    }

    @Override
    public T hasThisOne(Object val) {
        return this.addCrit(FilterOperator.EQUAL, val);
    }

    @Override
    public T hasAllOf(Iterable<?> vals) {
        Assert.parametersNotNull("vals", vals);
        Assert.parameterNotEmpty(vals, "vals");
        return this.addCrit(FilterOperator.ALL, vals);
    }

    @Override
    public T hasAnyOf(Iterable<?> vals) {
        Assert.parametersNotNull("vals", vals);
        if (log.isWarningEnabled() && !vals.iterator().hasNext()) {
            log.warning("Specified an empty list/collection with the '" + this.field + "' criteria");
        }
        return this.addCrit(FilterOperator.IN, vals);
    }

    @Override
    public T in(Iterable<?> vals) {
        return (T)this.hasAnyOf((Iterable)vals);
    }

    @Override
    public T hasThisElement(Object val) {
        Assert.parametersNotNull("val", val);
        return this.addCrit(FilterOperator.ELEMENT_MATCH, val);
    }

    @Override
    public T hasNoneOf(Iterable<?> vals) {
        Assert.parametersNotNull("vals", vals);
        Assert.parameterNotEmpty(vals, "vals");
        return this.addCrit(FilterOperator.NOT_IN, vals);
    }

    @Override
    public T notIn(Iterable<?> vals) {
        return (T)this.hasNoneOf((Iterable)vals);
    }

    @Override
    public T lessThan(Object val) {
        Assert.parametersNotNull("val", val);
        return this.addCrit(FilterOperator.LESS_THAN, val);
    }

    @Override
    public T lessThanOrEq(Object val) {
        Assert.parametersNotNull("val", val);
        return this.addCrit(FilterOperator.LESS_THAN_OR_EQUAL, val);
    }

    @Override
    public T notEqual(Object val) {
        return this.addCrit(FilterOperator.NOT_EQUAL, val);
    }

    @Override
    public T sizeEq(int val) {
        Assert.parametersNotNull("val", val);
        return this.addCrit(FilterOperator.SIZE, val);
    }

    @Override
    public T near(double x, double y) {
        return (T)this.near(x, y, false);
    }

    @Override
    public T near(double x, double y, double radius) {
        return (T)this.near(x, y, radius, false);
    }

    @Override
    public T near(double x, double y, double radius, boolean spherical) {
        return this.addGeoCrit(FilterOperator.NEAR, new double[]{x, y}, spherical ? this.opts("$sphere", true, "$maxDistance", radius) : null);
    }

    @Override
    public T near(double x, double y, boolean spherical) {
        return this.addGeoCrit(FilterOperator.NEAR, new double[]{x, y}, spherical ? this.opts("$sphere", true) : null);
    }

    @Override
    public T within(double x, double y, double radius) {
        return (T)this.within(x, y, radius, false);
    }

    @Override
    public T within(double x, double y, double radius, boolean spherical) {
        return this.addGeoCrit(FilterOperator.WITHIN_CIRCLE, new Object[]{new double[]{x, y}, radius}, spherical ? this.opts("$sphere", true) : null);
    }

    @Override
    public T within(double x1, double y1, double x2, double y2) {
        return this.addGeoCrit(FilterOperator.WITHIN_BOX, new double[][]{{x1, y1}, {x2, y2}}, null);
    }

    private Map<String, Object> opts(String s, Object v) {
        HashMap<String, Object> opts = new HashMap<String, Object>();
        opts.put(s, v);
        return opts;
    }

    private Map<String, Object> opts(String s1, Object v1, String s2, Object v2) {
        HashMap<String, Object> opts = new HashMap<String, Object>();
        opts.put(s1, v1);
        opts.put(s2, v2);
        return opts;
    }
}

