/*
 * Decompiled with CFR 0.152.
 */
package play.db;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import javax.sql.DataSource;
import org.hibernate.ejb.EntityManagerImpl;
import play.db.jpa.JPA;
import play.exceptions.DatabaseException;

public class MDB {
    public static Map<String, DataSource> datasources = null;
    static ThreadLocal<Connection> localConnection = new ThreadLocal();

    public static void close() {
        if (localConnection.get() != null) {
            try {
                Connection connection = localConnection.get();
                localConnection.set(null);
                connection.close();
            }
            catch (Exception e) {
                throw new DatabaseException("It's possible than the connection was not propertly closed !", (Throwable)e);
            }
        }
    }

    public static Connection getConnection(String dbKey) {
        try {
            if (JPA.isEnabled()) {
                return ((EntityManagerImpl)JPA.em()).getSession().connection();
            }
            if (localConnection.get() != null) {
                return localConnection.get();
            }
            Connection connection = datasources.get(dbKey).getConnection();
            localConnection.set(connection);
            return connection;
        }
        catch (SQLException ex) {
            throw new DatabaseException("Cannot obtain a new connection (" + ex.getMessage() + ")", (Throwable)ex);
        }
        catch (NullPointerException e) {
            if (datasources.get(dbKey) == null) {
                throw new DatabaseException("No database found under key '" + dbKey + "'. Check the configuration of your application.", (Throwable)e);
            }
            throw e;
        }
    }

    public static boolean execute(String SQL) {
        try {
            return MDB.getConnection(null).createStatement().execute(SQL);
        }
        catch (SQLException ex) {
            throw new DatabaseException(ex.getMessage(), (Throwable)ex);
        }
    }

    public static ResultSet executeQuery(String SQL) {
        try {
            return MDB.getConnection(null).createStatement().executeQuery(SQL);
        }
        catch (SQLException ex) {
            throw new DatabaseException(ex.getMessage(), (Throwable)ex);
        }
    }
}

