/*
 * Decompiled with CFR 0.152.
 */
package play.db;

import com.mchange.v2.c3p0.ComboPooledDataSource;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import play.Logger;
import play.Play;
import play.PlayPlugin;
import play.db.DBPlugin;
import play.db.MDB;

public class MDBPlugin
extends PlayPlugin {
    private static final String MDB_ALL_KEY = "all";
    private static final String MDB_CONF_PREFIX = "mdb.";
    private static final String MDB_DRIVER_PREFIX = "mdb.driver.";
    private static final String MDB_URL_PREFIX = "mdb.url.";
    private static final String MDB_USER_PREFIX = "mdb.user.";
    private static final String MDB_PASS_PREFIX = "mdb.pass.";
    private static final String MDB_POOL_TIMEOUT_PREFIX = "mdb.pool.timeout.";
    private static final String MDB_POOL_MAX_PREFIX = "mdb.pool.maxSize.";
    private static final String MDB_POOL_MIN_PREFIX = "mdb.pool.minSize.";
    private static final String MDB_KEY_PREFIX = "mdb.key.";

    public void onApplicationStart() {
        if (MDBPlugin.changed()) {
            MDB.datasources = new HashMap<String, DataSource>();
            Map<Object, Object> dbMap = new HashMap();
            try {
                dbMap = MDBPlugin.extractDbParameters();
            }
            catch (Exception e) {
                Logger.error((Throwable)e, (String)"Error collecting data for multiple database plugin", (Object[])new Object[0]);
            }
            DbParameters allEntry = (DbParameters)dbMap.get(MDB_ALL_KEY);
            if (allEntry == null) {
                allEntry = new DbParameters();
            }
            for (Map.Entry<Object, Object> parm : dbMap.entrySet()) {
                try {
                    if (MDB_ALL_KEY.equals(parm.getKey())) continue;
                    DbParameters db = (DbParameters)parm.getValue();
                    db.inherit(allEntry);
                    this.makeConnection(db);
                }
                catch (Exception e) {
                    Logger.error((Throwable)e, (String)("Cannot connect to the database [" + (String)parm.getKey() + "]: %s"), (Object[])new Object[]{e.getMessage()});
                }
            }
        }
    }

    private static Map<String, DbParameters> extractDbParameters() {
        HashMap<String, DbParameters> dbMap = new HashMap<String, DbParameters>();
        Properties p = Play.configuration;
        for (Map.Entry<Object, Object> entry : p.entrySet()) {
            if (entry.getKey() instanceof String) {
                String propKey = (String)entry.getKey();
                if (propKey == null || !propKey.startsWith(MDB_CONF_PREFIX)) continue;
                String mapKey = StringUtils.substringAfterLast((String)propKey, (String)".");
                DbParameters mapEntry = (DbParameters)dbMap.get(mapKey);
                if (mapEntry == null) {
                    mapEntry = new DbParameters();
                    dbMap.put(mapKey, mapEntry);
                }
                if (propKey.startsWith(MDB_DRIVER_PREFIX)) {
                    mapEntry.driver = (String)entry.getValue();
                    continue;
                }
                if (propKey.startsWith(MDB_DRIVER_PREFIX)) {
                    mapEntry.driver = (String)entry.getValue();
                    continue;
                }
                if (propKey.startsWith(MDB_KEY_PREFIX)) {
                    mapEntry.key = (String)entry.getValue();
                    continue;
                }
                if (propKey.startsWith(MDB_URL_PREFIX)) {
                    mapEntry.url = (String)entry.getValue();
                    continue;
                }
                if (propKey.startsWith(MDB_USER_PREFIX)) {
                    mapEntry.user = (String)entry.getValue();
                    continue;
                }
                if (propKey.startsWith(MDB_PASS_PREFIX)) {
                    mapEntry.pass = (String)entry.getValue();
                    continue;
                }
                if (propKey.startsWith(MDB_POOL_TIMEOUT_PREFIX)) {
                    mapEntry.poolTimeout = (String)entry.getValue();
                    continue;
                }
                if (propKey.startsWith(MDB_POOL_MAX_PREFIX)) {
                    mapEntry.poolMaxSize = (String)entry.getValue();
                    continue;
                }
                if (propKey.startsWith(MDB_POOL_MIN_PREFIX)) {
                    mapEntry.poolMinSize = (String)entry.getValue();
                    continue;
                }
                Logger.warn((String)("Unrecognized MDB key: " + propKey), (Object[])new Object[0]);
                continue;
            }
            Logger.warn((String)("Unexpected non-string property key: " + entry.getKey()), (Object[])new Object[0]);
        }
        return dbMap;
    }

    public String getStatus() {
        StringWriter sw = new StringWriter();
        PrintWriter out = new PrintWriter(sw);
        out.println("         Multiple DB sources:");
        out.println("=================================================");
        if (MDB.datasources == null || MDB.datasources.isEmpty()) {
            out.println("Datasources:");
            out.println("~~~~~~~~~~~");
            out.println("(not yet connected)");
            return sw.toString();
        }
        for (Map.Entry<String, DataSource> entry : MDB.datasources.entrySet()) {
            if (entry == null || entry.getValue() == null || !(entry.getValue() instanceof ComboPooledDataSource)) {
                out.println("Datasource [" + entry.getKey() + "]:");
                out.println("~~~~~~~~~~~");
                out.println("(not yet connected)");
                continue;
            }
            ComboPooledDataSource datasource = (ComboPooledDataSource)entry.getValue();
            out.println("Datasource [" + entry.getKey() + "]:");
            out.println("~~~~~~~~~~~");
            out.println("Jdbc url: " + datasource.getJdbcUrl());
            out.println("Jdbc driver: " + datasource.getDriverClass());
            out.println("Jdbc user: " + datasource.getUser());
            out.println("Jdbc password: " + datasource.getPassword());
            out.println("Min pool size: " + datasource.getMinPoolSize());
            out.println("Max pool size: " + datasource.getMaxPoolSize());
            out.println("Initial pool size: " + datasource.getInitialPoolSize());
            out.println("Checkout timeout: " + datasource.getCheckoutTimeout());
            out.println("");
        }
        out.println("=================================================");
        return sw.toString();
    }

    public void invocationFinally() {
        MDB.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeConnection(DbParameters parms) throws Exception {
        String driver = parms.driver;
        try {
            Driver d = (Driver)Class.forName(driver, true, (ClassLoader)Play.classloader).newInstance();
            DriverManager.registerDriver((Driver)new DBPlugin.ProxyDriver(d));
        }
        catch (Exception e) {
            throw new Exception("Driver not found (" + driver + ")");
        }
        Connection fake = null;
        try {
            fake = parms.user == null ? DriverManager.getConnection(parms.url) : DriverManager.getConnection(parms.url, parms.user, parms.pass);
        }
        finally {
            if (fake != null) {
                fake.close();
            }
        }
        System.setProperty("com.mchange.v2.log.MLog", "com.mchange.v2.log.FallbackMLog");
        System.setProperty("com.mchange.v2.log.FallbackMLog.DEFAULT_CUTOFF_LEVEL", "OFF");
        ComboPooledDataSource ds = new ComboPooledDataSource();
        ds.setDriverClass(parms.driver);
        ds.setJdbcUrl(parms.url);
        ds.setUser(parms.user);
        ds.setPassword(parms.pass);
        ds.setAcquireRetryAttempts(1);
        ds.setAcquireRetryDelay(0);
        ds.setCheckoutTimeout(Integer.parseInt(StringUtils.defaultIfEmpty((String)parms.poolTimeout, (String)"5000")));
        ds.setBreakAfterAcquireFailure(true);
        ds.setMaxPoolSize(Integer.parseInt(StringUtils.defaultIfEmpty((String)parms.poolMaxSize, (String)"30")));
        ds.setMinPoolSize(Integer.parseInt(StringUtils.defaultIfEmpty((String)parms.poolMinSize, (String)"1")));
        ds.setTestConnectionOnCheckout(true);
        MDB.datasources.put(parms.key, (DataSource)ds);
        Connection c = null;
        try {
            c = ds.getConnection();
        }
        finally {
            if (c != null) {
                c.close();
            }
        }
        Logger.info((String)"Connected to %s", (Object[])new Object[]{ds.getJdbcUrl()});
    }

    private static boolean changed() {
        Map<String, DbParameters> dbMap = MDBPlugin.extractDbParameters();
        DbParameters allEntry = dbMap.get(MDB_ALL_KEY);
        if (allEntry == null) {
            allEntry = new DbParameters();
        }
        boolean hasChanged = false;
        for (Map.Entry<String, DbParameters> parm : dbMap.entrySet()) {
            DbParameters db;
            if (MDB.datasources == null || MDB.datasources.isEmpty()) {
                return true;
            }
            if (MDB_ALL_KEY.equals(parm.getKey()) || (db = parm.getValue()) == null || db.driver == null || db.url == null) continue;
            ComboPooledDataSource ds = (ComboPooledDataSource)MDB.datasources.get(parm.getKey());
            if (ds == null) {
                hasChanged |= true;
                continue;
            }
            if (!StringUtils.defaultString((String)db.driver).equals(ds.getDriverClass())) {
                hasChanged |= true;
            }
            if (!StringUtils.defaultString((String)db.url).equals(ds.getJdbcUrl())) {
                hasChanged |= true;
            }
            if (!StringUtils.defaultString((String)db.user).equals(ds.getUser())) {
                hasChanged |= true;
            }
            if (StringUtils.defaultString((String)db.pass).equals(ds.getPassword())) continue;
            hasChanged |= true;
        }
        return hasChanged;
    }

    private static class DbParameters {
        public String key;
        public String url;
        public String driver;
        public String user;
        public String pass;
        public String poolTimeout;
        public String poolMaxSize;
        public String poolMinSize;

        private DbParameters() {
        }

        public void inherit(DbParameters allEntry) {
            this.driver = StringUtils.defaultIfEmpty((String)this.driver, (String)allEntry.driver);
            this.pass = StringUtils.defaultIfEmpty((String)this.pass, (String)allEntry.pass);
            this.user = StringUtils.defaultIfEmpty((String)this.user, (String)allEntry.user);
            this.poolMaxSize = StringUtils.defaultIfEmpty((String)this.poolMaxSize, (String)allEntry.poolMaxSize);
            this.poolMinSize = StringUtils.defaultIfEmpty((String)this.poolMinSize, (String)allEntry.poolMinSize);
            this.poolTimeout = StringUtils.defaultIfEmpty((String)this.poolTimeout, (String)allEntry.poolTimeout);
            this.url = StringUtils.defaultIfEmpty((String)this.url, (String)allEntry.url);
        }
    }
}

