/*
 * Decompiled with CFR 0.152.
 */
package play.db.jpa;

import com.mchange.v2.c3p0.ComboPooledDataSource;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.FlushModeType;
import javax.persistence.PersistenceException;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.Level;
import org.hibernate.CallbackException;
import org.hibernate.EmptyInterceptor;
import org.hibernate.Interceptor;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.ejb.Ejb3Configuration;
import org.hibernate.type.Type;
import play.CorePlugin;
import play.Logger;
import play.Play;
import play.db.MDB;
import play.db.jpa.DomainDBKeyExtractor;
import play.db.jpa.InvalidDatabaseException;
import play.db.jpa.JPA;
import play.db.jpa.JPASupport;
import play.db.jpa.JPQLDialect;
import play.db.jpa.RequestDBKeyExtractor;
import play.exceptions.JPAException;
import play.mvc.Http;
import play.mvc.results.NotFound;
import play.utils.Utils;

public class MJPAPlugin
extends CorePlugin {
    public static Log log = LogFactory.getLog(MJPAPlugin.class);
    public static boolean autoTxs = true;
    public static Map<String, EntityManagerFactory> factoryMap = new HashMap<String, EntityManagerFactory>();
    public static RequestDBKeyExtractor keyExtractor = new DomainDBKeyExtractor();

    public void beforeInvocation() {
        JPA.entityManagerFactory = null;
        String dbKey = keyExtractor.extractKey(Http.Request.current());
        try {
            if (dbKey != null) {
                MJPAPlugin.startTx(dbKey, false);
            }
        }
        catch (InvalidDatabaseException e) {
            throw new NotFound(e.getMessage());
        }
    }

    public static void startTx(String dbKey, boolean readOnly) {
        EntityManagerFactory factory = factoryMap.get(dbKey);
        if (dbKey == null || factory == null) {
            throw new InvalidDatabaseException("connection: " + dbKey);
        }
        EntityManager manager = factory.createEntityManager();
        manager.setFlushMode(FlushModeType.COMMIT);
        if (autoTxs) {
            manager.getTransaction().begin();
        }
        JPA.createContext((EntityManager)manager, (boolean)readOnly);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeTx(boolean rollback) {
        block10: {
            if (JPA.local.get() == null || JPA.get().entityManager == null) {
                return;
            }
            EntityManager manager = JPA.get().entityManager;
            try {
                if (!autoTxs || !manager.getTransaction().isActive()) break block10;
                if (JPA.get().readonly || rollback || manager.getTransaction().getRollbackOnly()) {
                    manager.getTransaction().rollback();
                    break block10;
                }
                try {
                    if (autoTxs) {
                        manager.getTransaction().commit();
                    }
                }
                catch (Throwable e) {
                    for (int i = 0; i < 10; ++i) {
                        if (e instanceof PersistenceException && e.getCause() != null) {
                            e = e.getCause();
                            break;
                        }
                        if ((e = e.getCause()) == null) break;
                    }
                    throw new JPAException("Cannot commit", e);
                }
            }
            finally {
                manager.close();
                JPA.clearContext();
            }
        }
    }

    public void afterInvocation() {
        MJPAPlugin.closeTx(false);
    }

    public void afterActionInvocation() {
        MJPAPlugin.closeTx(false);
    }

    public void onInvocationException(Throwable e) {
        MJPAPlugin.closeTx(true);
    }

    public void invocationFinally() {
        MJPAPlugin.closeTx(true);
    }

    static String getDefaultDialect(String driver) {
        String dialect = Play.configuration.getProperty("mjpa.dialect");
        if (dialect != null) {
            return dialect;
        }
        if (driver.equals("org.hsqldb.jdbcDriver")) {
            return "org.hibernate.dialect.HSQLDialect";
        }
        if (driver.equals("com.mysql.jdbc.Driver")) {
            return "play.db.jpa.MySQLDialect";
        }
        throw new UnsupportedOperationException("I do not know which hibernate dialect to use with " + driver + ", use the property jpa.dialect in config file");
    }

    public void onApplicationStart() {
        List extractors;
        if (JPA.entityManagerFactory == null) {
            List classes = Play.classloader.getAnnotatedClasses(Entity.class);
            if (classes.isEmpty() && Play.configuration.getProperty("jpa.entities", "").equals("")) {
                return;
            }
            if (MDB.datasources == null || MDB.datasources.isEmpty()) {
                throw new JPAException("Cannot start a JPA manager without properly configured databases", (Throwable)new NullPointerException("No datasource"));
            }
            for (Map.Entry<String, DataSource> entry : MDB.datasources.entrySet()) {
                ComboPooledDataSource datasource = (ComboPooledDataSource)entry.getValue();
                Ejb3Configuration cfg = MJPAPlugin.buildEjbConfiguration(classes, datasource);
                Logger.trace((String)"Initializing JPA ...", (Object[])new Object[0]);
                try {
                    EntityManagerFactory factory;
                    JPA.entityManagerFactory = factory = cfg.buildEntityManagerFactory();
                    factoryMap.put(entry.getKey(), factory);
                    log.debug((Object)("Added datasource: " + datasource.getJdbcUrl()));
                }
                catch (PersistenceException e) {
                    throw new JPAException(e.getMessage(), e.getCause() != null ? e.getCause() : e);
                }
                JPQLDialect.instance = new JPQLDialect();
            }
        }
        if ((extractors = Play.classloader.getAssignableClasses(RequestDBKeyExtractor.class)).size() > 1) {
            throw new JPAException("Too many DB Key extract classes.  The Multiple DB plugin must use a single extractor class to specify its extractor.  These classes where found: " + extractors);
        }
        if (!extractors.isEmpty()) {
            Class clazz = (Class)extractors.get(0);
            try {
                keyExtractor = (RequestDBKeyExtractor)clazz.newInstance();
            }
            catch (InstantiationException e) {
                log.error((Object)"Unable to instantiate extractor class:", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                log.error((Object)"Invalid access to extractor class:", (Throwable)e);
            }
            log.debug((Object)("Using application DB key extractor class: " + keyExtractor.getClass().getName()));
        } else {
            log.debug((Object)("Using default DB key extractor class: " + keyExtractor.getClass().getName()));
        }
    }

    public static Ejb3Configuration buildEjbConfiguration(List<Class> classes, ComboPooledDataSource datasource) {
        String[] moreEntities;
        Ejb3Configuration cfg = new Ejb3Configuration();
        cfg.setDataSource((DataSource)datasource);
        if (!Play.configuration.getProperty("jpa.ddl", "update").equals("none")) {
            cfg.setProperty("hibernate.hbm2ddl.auto", Play.configuration.getProperty("jpa.ddl", "update"));
        }
        cfg.setProperty("hibernate.dialect", MJPAPlugin.getDefaultDialect(datasource.getDriverClass()));
        cfg.setProperty("javax.persistence.transaction", "RESOURCE_LOCAL");
        cfg.setInterceptor((Interceptor)new EmptyInterceptor(){
            private static final long serialVersionUID = -8670026536584880961L;

            public int[] findDirty(Object o, Serializable id, Object[] arg2, Object[] arg3, String[] arg4, Type[] arg5) {
                if (o instanceof JPASupport && !((JPASupport)o).willBeSaved) {
                    return new int[0];
                }
                return null;
            }

            public boolean onCollectionUpdate(Object collection, Serializable key) throws CallbackException {
                if (collection instanceof PersistentCollection) {
                    Object o = ((PersistentCollection)collection).getOwner();
                    if (o instanceof JPASupport) {
                        return ((JPASupport)o).willBeSaved;
                    }
                } else {
                    System.out.println("HOO: Case not handled !!!");
                }
                return super.onCollectionUpdate(collection, key);
            }

            public boolean onCollectionRecreate(Object collection, Serializable key) throws CallbackException {
                if (collection instanceof PersistentCollection) {
                    Object o = ((PersistentCollection)collection).getOwner();
                    if (o instanceof JPASupport) {
                        return ((JPASupport)o).willBeSaved;
                    }
                } else {
                    System.out.println("HOO: Case not handled !!!");
                }
                return super.onCollectionRecreate(collection, key);
            }

            public boolean onCollectionRemove(Object collection, Serializable key) throws CallbackException {
                if (collection instanceof PersistentCollection) {
                    Object o = ((PersistentCollection)collection).getOwner();
                    if (o instanceof JPASupport) {
                        return ((JPASupport)o).willBeSaved;
                    }
                } else {
                    System.out.println("HOO: Case not handled !!!");
                }
                return super.onCollectionRemove(collection, key);
            }
        });
        if (Play.configuration.getProperty("jpa.debugSQL", "false").equals("true")) {
            org.apache.log4j.Logger.getLogger((String)"org.hibernate.SQL").setLevel(Level.ALL);
        } else {
            org.apache.log4j.Logger.getLogger((String)"org.hibernate.SQL").setLevel(Level.OFF);
        }
        cfg.addProperties((Properties)Utils.Maps.filterMap((Map)Play.configuration, (String)"^hibernate\\..*"));
        try {
            Field field = cfg.getClass().getDeclaredField("overridenClassLoader");
            field.setAccessible(true);
            field.set(cfg, Play.classloader);
        }
        catch (Exception e) {
            Logger.error((Throwable)e, (String)"Error trying to override the hibernate classLoader (new hibernate version ???)", (Object[])new Object[0]);
        }
        for (Class clazz : classes) {
            if (!clazz.isAnnotationPresent(Entity.class)) continue;
            cfg.addAnnotatedClass(clazz);
            Logger.trace((String)"JPA Model : %s", (Object[])new Object[]{clazz});
        }
        for (String entity : moreEntities = Play.configuration.getProperty("jpa.entities", "").split(", ")) {
            if (entity.trim().equals("")) continue;
            try {
                cfg.addAnnotatedClass(Play.classloader.loadClass(entity));
            }
            catch (Exception e) {
                Logger.warn((String)"JPA -> Entity not found: %s", (Object[])new Object[]{entity});
            }
        }
        return cfg;
    }
}

