/*
 * Decompiled with CFR 0.152.
 */
package com.sampullara.mustache;

import com.sampullara.mustache.MustacheCompiler;
import com.sampullara.mustache.MustacheException;
import com.sampullara.mustache.Scope;
import com.sampullara.util.FutureWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.jackson.JsonNode;

public abstract class Mustache {
    protected Logger logger = Logger.getLogger(this.getClass().getName());
    private File root;
    private String path;
    private static final boolean debug = Boolean.getBoolean("mustache.debug");
    private static Map<String, Boolean> missing = new ConcurrentHashMap<String, Boolean>();
    private static Pattern findToEncode = Pattern.compile("&(?!\\w+;)|[\"<>\\\\]");

    public void setRoot(File root) {
        this.root = root;
    }

    public File getRoot() {
        return this.root;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public abstract void execute(FutureWriter var1, Scope var2) throws MustacheException;

    protected void enqueue(FutureWriter writer, final Mustache m, final Scope s) throws IOException {
        writer.enqueue(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                FutureWriter fw = new FutureWriter();
                m.setRoot(Mustache.this.getRoot());
                m.setPath(Mustache.this.getPath());
                m.execute(fw, s);
                return fw;
            }
        });
    }

    protected void write(Writer writer, Scope s, String name, boolean encode) throws MustacheException {
        Object value = this.getValue(s, name);
        if (value != null) {
            if (value instanceof Future) {
                try {
                    if (writer instanceof FutureWriter) {
                        FutureWriter fw = (FutureWriter)writer;
                        fw.enqueue((Future)value);
                        return;
                    }
                    value = ((Future)value).get();
                }
                catch (Exception e) {
                    throw new MustacheException("Failed to evaluate future value: " + name, e);
                }
            }
            if (value instanceof FutureWriter) {
                if (writer instanceof FutureWriter) {
                    FutureWriter fw = (FutureWriter)writer;
                    final Object finalValue = value;
                    try {
                        fw.enqueue(new Callable<Object>(){

                            @Override
                            public Object call() throws Exception {
                                return finalValue;
                            }
                        });
                    }
                    catch (IOException e) {
                        throw new MustacheException("Failed to enqueue future writer", e);
                    }
                }
            } else {
                String string = String.valueOf(value);
                if (encode) {
                    string = Mustache.encode(string);
                }
                try {
                    writer.write(string);
                }
                catch (IOException e) {
                    throw new MustacheException("Failed to write: " + e);
                }
            }
        }
    }

    protected Iterable<Scope> iterable(final Scope s, String name) {
        boolean times = false;
        final String finalName = name;
        Object value = this.getValue(s, name);
        if (value instanceof Future) {
            try {
                value = ((Future)value).get();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (value == null || value instanceof Boolean && !((Boolean)value).booleanValue()) {
            return Scope.EMPTY;
        }
        final Object finalValue = value;
        return new Iterable<Scope>(){

            @Override
            public Iterator<Scope> iterator() {
                return new Iterator<Scope>(){
                    Iterator i;
                    {
                        this.i = finalValue instanceof Iterable && (!(finalValue instanceof JsonNode) || ((JsonNode)finalValue).isArray()) ? ((Iterable)finalValue).iterator() : new SingleValueIterator(finalValue);
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }

                    @Override
                    public Scope next() {
                        Object value = this.i.next();
                        Scope scope = !(value instanceof Boolean) ? new Scope(value, s) : new Scope(s);
                        scope.put(finalName, value);
                        return scope;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    protected void partial(FutureWriter writer, Scope s, String name) throws MustacheException {
        MustacheCompiler c = new MustacheCompiler(this.root);
        if (name != null) {
            Object parent = s.get(name);
            Scope scope = parent == null ? s : new Scope(parent, s);
            Mustache mustache = c.parseFile(name + ".html");
            mustache.execute(writer, scope);
        }
    }

    protected Iterable<Scope> inverted(Scope s, String name) {
        boolean isntEmpty;
        Object value = this.getValue(s, name);
        boolean bl = isntEmpty = value instanceof Iterable && ((Iterable)value).iterator().hasNext();
        if (isntEmpty || value instanceof Boolean && ((Boolean)value).booleanValue() || value != null && !(value instanceof Iterable) && !(value instanceof Boolean)) {
            return Scope.EMPTY;
        }
        Scope scope = new Scope(s);
        scope.put(name, true);
        return Arrays.asList(scope);
    }

    protected Object getValue(Scope s, String name) {
        try {
            Object o = s.get(name);
            if (o == null && debug) {
                StringBuilder sb = new StringBuilder();
                for (StackTraceElement ste : Thread.currentThread().getStackTrace()) {
                    String className = ste.getClassName();
                    if (!className.startsWith("com.sampullara.mustaches.Mustache")) continue;
                    sb.append(this.path).append(":").append(ste.getLineNumber());
                    break;
                }
                String location = name + " @ " + sb;
                if (!name.startsWith("_") && missing.put(location, true) == null) {
                    Object parent = s.getParent();
                    this.logger.warning("No field, method or key found for: " + location + (parent == null ? "" : " with base scope parent: " + parent.getClass().getName()));
                }
            }
            if (o == Scope.NULL) {
                return null;
            }
            return o;
        }
        catch (Exception e) {
            this.logger.warning("Failed: " + e + " using " + name);
            return null;
        }
    }

    public static String encode(String value) {
        StringBuffer sb = new StringBuffer();
        Matcher matcher = findToEncode.matcher(value);
        while (matcher.find()) {
            char c = matcher.group().charAt(0);
            switch (c) {
                case '&': {
                    matcher.appendReplacement(sb, "&amp;");
                    break;
                }
                case '\\': {
                    matcher.appendReplacement(sb, "\\\\");
                    break;
                }
                case '\"': {
                    matcher.appendReplacement(sb, "\"");
                    break;
                }
                case '<': {
                    matcher.appendReplacement(sb, "&lt;");
                    break;
                }
                case '>': {
                    matcher.appendReplacement(sb, "&gt;");
                }
            }
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private class SingleValueIterator
    implements Iterator {
        private boolean done;
        private Object value;

        SingleValueIterator(Object value) {
            this.value = value;
        }

        @Override
        public boolean hasNext() {
            return !this.done;
        }

        public Object next() {
            if (!this.done) {
                this.done = true;
                return this.value;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            this.done = true;
        }
    }
}

