/*
 * Decompiled with CFR 0.152.
 */
package com.sampullara.mustache;

import com.sampullara.mustache.Mustache;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.codehaus.jackson.JsonNode;

public class Scope
extends HashMap {
    protected static Map<Class, Map<String, AccessibleObject>> cache = new ConcurrentHashMap<Class, Map<String, AccessibleObject>>();
    public static final Iterable EMPTY = new ArrayList(0);
    public static final Object NULL = new Object(){

        public String toString() {
            return "";
        }
    };
    private Object parent;
    private Scope parentScope;
    private Logger logger;
    private static Nothing nothing = new Nothing();

    public Scope() {
        this.logger = Logger.getLogger(this.getClass().getName());
    }

    public Scope(Object parent) {
        if (parent instanceof Scope) {
            this.parentScope = (Scope)parent;
            this.logger = Logger.getLogger(this.getClass().getName());
        } else {
            this.parent = parent;
            this.logger = Logger.getLogger(parent.getClass().getName());
        }
    }

    public Scope(Scope parentScope) {
        this.parentScope = parentScope;
        this.logger = Logger.getLogger(this.getClass().getName());
    }

    public Scope(Object parent, Scope parentScope) {
        this.parentScope = parentScope;
        this.parent = parent;
        this.logger = Logger.getLogger(this.getClass().getName());
    }

    public Scope getParentScope() {
        return this.parentScope;
    }

    @Override
    public Object get(Object o) {
        return this.get(o, this);
    }

    public Object get(Object o, Scope scope) {
        String name = o.toString();
        Object value = null;
        String[] components = name.split("\\.");
        Scope current = this;
        Scope currentScope = scope;
        for (String component : components) {
            value = current.localGet(currentScope, component);
            if (value == null || value == NULL) {
                return value;
            }
            currentScope = current;
            current = new Scope(value);
        }
        return value;
    }

    private Object localGet(Scope scope, String name) {
        Object v = super.get(name);
        if (v == null && this.parent != null) {
            if (this.parent instanceof Future) {
                try {
                    this.parent = ((Future)this.parent).get();
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to get value from future");
                }
            }
            v = this.parent instanceof Map ? ((Map)this.parent).get(name) : (this.parent instanceof JsonNode ? this.handleJsonNode(name) : this.handleObject(scope, name, v));
        }
        if (v == null && this.parentScope != null) {
            v = this.parentScope.get(name, scope);
        }
        if (v == null) {
            // empty if block
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object handleObject(Scope scope, String name, Object v) {
        Class<?> aClass = this.parent.getClass();
        Class<Mustache> clazz = Mustache.class;
        synchronized (Mustache.class) {
            Map<String, AccessibleObject> members = cache.get(aClass);
            if (members == null) {
                members = new ConcurrentHashMap<String, AccessibleObject>();
                cache.put(aClass, members);
            }
            // ** MonitorExit[var6_5] (shouldn't be in output)
            AccessibleObject member = members.get(name);
            if (member == nothing) {
                return null;
            }
            if (member == null) {
                try {
                    member = this.getField(name, aClass);
                    member.setAccessible(true);
                    members.put(name, member);
                }
                catch (NoSuchFieldException e) {
                    // empty catch block
                }
            }
            if (member == null) {
                try {
                    member = this.getMethod(name, aClass, new Class[0]);
                    member.setAccessible(true);
                    members.put(name, member);
                }
                catch (NoSuchMethodException e) {
                    try {
                        member = this.getMethod(name, aClass, Scope.class);
                        member.setAccessible(true);
                        members.put(name, member);
                    }
                    catch (NoSuchMethodException e1) {
                        // empty catch block
                    }
                }
            }
            try {
                Method method;
                if (member instanceof Field) {
                    Field field = (Field)member;
                    v = field.get(this.parent);
                    if (v == null) {
                        v = field.getType().isAssignableFrom(Iterable.class) ? EMPTY : NULL;
                    }
                } else if (member instanceof Method && (v = (method = (Method)member).getParameterTypes().length == 0 ? method.invoke(this.parent, new Object[0]) : method.invoke(this.parent, scope)) == null) {
                    v = method.getReturnType().isAssignableFrom(Iterable.class) ? EMPTY : NULL;
                }
            }
            catch (Exception e) {
                this.logger.log(Level.WARNING, "Failed to get value for " + name, e);
            }
            if (member == null) {
                members.put(name, nothing);
            }
            return v;
        }
    }

    private AccessibleObject getMethod(String name, Class aClass, Class ... params) throws NoSuchMethodException {
        Method member;
        try {
            member = aClass.getDeclaredMethod(name, params);
        }
        catch (NoSuchMethodException nsme) {
            Class superclass = aClass.getSuperclass();
            if (superclass != Object.class) {
                return this.getMethod(name, superclass, params);
            }
            throw nsme;
        }
        return member;
    }

    private AccessibleObject getField(String name, Class aClass) throws NoSuchFieldException {
        Field member;
        try {
            member = aClass.getDeclaredField(name);
        }
        catch (NoSuchFieldException nsfe) {
            Class superclass = aClass.getSuperclass();
            if (superclass != Object.class) {
                return this.getField(name, superclass);
            }
            throw nsfe;
        }
        return member;
    }

    private Object handleJsonNode(String name) {
        JsonNode jsonNode = (JsonNode)this.parent;
        JsonNode result = jsonNode.get(name);
        if (result == null || result.isNull()) {
            return null;
        }
        Object v = result.isTextual() ? result.getTextValue() : (result.isBoolean() ? Boolean.valueOf(result.getBooleanValue()) : result);
        return v;
    }

    public Object getParent() {
        return this.parent;
    }

    private static class Nothing
    extends AccessibleObject {
        private Nothing() {
        }
    }
}

