/*
 * Decompiled with CFR 0.152.
 */
package com.sampullara.util;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class CallbackFuture<T>
implements Future<T> {
    private T o;
    private boolean cancelled;
    private boolean isDone;
    private Throwable error;

    public synchronized void set(T o) {
        if (!this.isDone) {
            this.isDone = true;
            this.o = o;
            this.notify();
        }
    }

    public synchronized void error(Throwable error) {
        if (!this.isDone) {
            this.isDone = true;
            this.error = error;
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel(boolean interrupt) {
        CallbackFuture callbackFuture = this;
        synchronized (callbackFuture) {
            if (this.cancelled) {
                return true;
            }
            if (!this.isDone) {
                this.cancelled = true;
                this.isDone = true;
                this.notify();
                return true;
            }
            return false;
        }
    }

    @Override
    public synchronized boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public synchronized boolean isDone() {
        return this.isDone;
    }

    @Override
    public synchronized T get() throws InterruptedException, ExecutionException {
        while (!this.isDone) {
            this.wait();
        }
        if (this.cancelled) {
            throw new InterruptedException("Cancelled");
        }
        if (this.error != null) {
            throw new ExecutionException(this.error);
        }
        return this.o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        long start = System.currentTimeMillis();
        CallbackFuture callbackFuture = this;
        synchronized (callbackFuture) {
            long total;
            for (total = timeUnit.convert(l, TimeUnit.MILLISECONDS); !this.isDone && total > 0L; total -= System.currentTimeMillis() - start) {
                this.wait(total);
            }
            if (this.cancelled) {
                throw new InterruptedException("Cancelled");
            }
            if (this.error != null) {
                throw new ExecutionException(this.error);
            }
            if (total <= 0L) {
                throw new TimeoutException("Timed out after waiting: " + (System.currentTimeMillis() - start) + "ms");
            }
            return this.o;
        }
    }
}

