/*
 * Decompiled with CFR 0.152.
 */
package com.sampullara.mustache;

import com.sampullara.mustache.Mustache;
import com.sampullara.mustache.MustacheException;
import com.sampullara.util.RuntimeJavaCompiler;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;

public class MustacheCompiler {
    private File root;
    private static String header = MustacheCompiler.getText("/header.txt");
    private static String middle = MustacheCompiler.getText("/middle.txt");
    private static String footer = MustacheCompiler.getText("/footer.txt");
    private Logger logger = Logger.getLogger(this.getClass().getName());
    private boolean debug = false;
    private String superclass;
    private String outputDirectory = System.getProperty("mustcache");

    public void setDebug() {
        this.debug = true;
    }

    private static String getText(String template) {
        InputStream stream = MustacheCompiler.class.getResourceAsStream(template);
        BufferedReader br = new BufferedReader(new InputStreamReader(stream));
        return MustacheCompiler.getText(template, br);
    }

    private static String getText(String template, BufferedReader br) {
        StringBuilder text = new StringBuilder();
        try {
            String line;
            while ((line = br.readLine()) != null) {
                text.append(line);
            }
            br.close();
        }
        catch (IOException e) {
            throw new AssertionError((Object)("Failed to read template file: " + template));
        }
        return text.toString();
    }

    public MustacheCompiler() {
        this.root = new File(".");
    }

    public MustacheCompiler(File root) {
        this.root = root;
    }

    public MustacheCompiler(File root, String outputDirectory) {
        this(root);
        this.outputDirectory = outputDirectory;
    }

    public void setSuperclass(String superclass) {
        this.superclass = superclass;
    }

    public void setOutputDirectory(String outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public synchronized Mustache parse(String partial) throws MustacheException {
        AtomicInteger currentLine = new AtomicInteger(0);
        BufferedReader br = new BufferedReader(new StringReader(partial));
        return this.compile(br, new Stack<String>(), currentLine, null);
    }

    public synchronized Mustache parseFile(String path) throws MustacheException {
        BufferedReader br;
        AtomicInteger currentLine = new AtomicInteger(0);
        File file = new File(this.root, path);
        try {
            br = new BufferedReader(new FileReader(file));
        }
        catch (FileNotFoundException e) {
            throw new MustacheException("Mustache file not found: " + file);
        }
        Mustache result = this.compile(br, new Stack<String>(), currentLine, null);
        result.setPath(path);
        return result;
    }

    public Mustache compile(BufferedReader br) throws MustacheException {
        return this.compile(br, new Stack<String>(), new AtomicInteger(0), this.getClass().getClassLoader());
    }

    public Mustache compile(BufferedReader br, Stack<String> scope, AtomicInteger currentLine, ClassLoader parent) throws MustacheException {
        Mustache result;
        AtomicInteger num = new AtomicInteger(0);
        StringBuilder code = new StringBuilder();
        int startingLines = currentLine.get();
        code.append(" extends ");
        if (this.superclass == null) {
            code.append("Mustache");
        } else {
            code.append(this.superclass);
        }
        code.append(" {");
        code.append(middle);
        String sm = "{{";
        String em = "}}";
        try {
            int c;
            StringBuilder template = new StringBuilder();
            boolean iterable = currentLine.get() != 0;
            currentLine.compareAndSet(0, 1);
            boolean onlywhitespace = true;
            block15: while ((c = br.read()) != -1) {
                if (c == 13) continue;
                if (c == 10) {
                    this.writeText(code, template.toString());
                    template = new StringBuilder();
                    currentLine.incrementAndGet();
                    if (!iterable || iterable && !onlywhitespace) {
                        code.append("w.write(\"\\n\");\n");
                    } else {
                        code.append("\n");
                    }
                    iterable = false;
                    onlywhitespace = true;
                    continue;
                }
                if (c == sm.charAt(0)) {
                    br.mark(1);
                    if (br.read() == sm.charAt(1)) {
                        StringBuilder sb = new StringBuilder();
                        while ((c = br.read()) != -1) {
                            if (c == em.charAt(0)) {
                                br.mark(1);
                                if (br.read() == em.charAt(1)) break;
                                br.reset();
                            }
                            sb.append((char)c);
                        }
                        String command = sb.toString().trim();
                        char ch = command.charAt(0);
                        switch (ch) {
                            case '#': 
                            case '^': {
                                String startTag = sb.substring(1).trim();
                                scope.push(startTag);
                                int start = currentLine.get();
                                Mustache sub = this.compile(br, scope, currentLine, parent);
                                int lines = currentLine.get() - start;
                                if (!onlywhitespace || lines == 0) {
                                    this.writeText(code, template.toString());
                                }
                                template = new StringBuilder();
                                parent = sub.getClass().getClassLoader();
                                if (this.debug) {
                                    code.append("System.err.println(\"#").append(startTag).append("\");");
                                }
                                int variableNum = num.incrementAndGet();
                                code.append("for (Scope s").append(variableNum);
                                if (ch == '#') {
                                    code.append(":iterable(s, \"");
                                } else {
                                    code.append(":inverted(s, \"");
                                }
                                code.append(startTag);
                                code.append("\")) {");
                                code.append("enqueue(w, new ").append(sub.getClass().getName());
                                code.append("(), s").append(variableNum).append(");");
                                code.append("}");
                                for (int i = 0; i < lines; ++i) {
                                    code.append("/* sub */\n");
                                }
                                iterable = lines != 0;
                                break;
                            }
                            case '/': {
                                String expected;
                                if (!onlywhitespace) {
                                    this.writeText(code, template.toString());
                                }
                                template = new StringBuilder();
                                String endTag = sb.substring(1).trim();
                                if (!endTag.equals(expected = scope.pop())) {
                                    throw new MustacheException("Mismatched start/end tags: " + expected + " != " + endTag + " at " + currentLine);
                                }
                                if (!this.debug) break block15;
                                code.append("System.err.println(\"/").append(endTag).append("\");");
                                break block15;
                            }
                            case '>': {
                                this.writeText(code, template.toString());
                                template = new StringBuilder();
                                String partialName = sb.substring(1).trim();
                                code.append("partial(w, s, \"").append(partialName).append("\");");
                                break;
                            }
                            case '{': {
                                this.writeText(code, template.toString());
                                template = new StringBuilder();
                                if (em.charAt(1) != '}' || br.read() == 125) {
                                    code.append("write(w, s, \"").append(sb.substring(1).trim()).append("\", false);");
                                    break;
                                }
                                throw new MustacheException("Unescaped section not terminated properly: " + sb + " at " + currentLine);
                            }
                            case '&': {
                                this.writeText(code, template.toString());
                                template = new StringBuilder();
                                code.append("write(w, s, \"").append(sb.substring(1).trim()).append("\", false);");
                                break;
                            }
                            case '%': {
                                this.writeText(code, template.toString());
                                template = new StringBuilder();
                                this.logger.warning("Pragmas are unsupported");
                                break;
                            }
                            case '!': {
                                this.writeText(code, template.toString());
                                template = new StringBuilder();
                                break;
                            }
                            default: {
                                this.writeText(code, template.toString());
                                template = new StringBuilder();
                                code.append("write(w, s, \"").append(command).append("\", true);");
                                break;
                            }
                        }
                        continue;
                    }
                    br.reset();
                }
                onlywhitespace = (c == 32 || c == 9) && onlywhitespace;
                template.append((char)c);
            }
            this.writeText(code, template.toString());
            code.append(footer);
        }
        catch (IOException e) {
            throw new MustacheException("Failed to read: " + e);
        }
        try {
            MessageDigest md = MessageDigest.getInstance("SHA1");
            byte[] digest = md.digest(code.toString().getBytes(Charset.forName("UTF-8")));
            StringBuilder hash = new StringBuilder();
            for (byte aDigest : digest) {
                hash.append(Integer.toHexString(0xFF & aDigest));
            }
            String className = "Mustache" + hash;
            try {
                ClassLoader classLoader = parent == null ? MustacheCompiler.class.getClassLoader() : parent;
                Mustache mustache = (Mustache)classLoader.loadClass("com.sampullara.mustaches." + className).newInstance();
                mustache.setRoot(this.root);
                return mustache;
            }
            catch (Exception e) {
                StringBuilder declaration = new StringBuilder();
                for (int i = 0; i < startingLines; ++i) {
                    declaration.append("\n");
                }
                declaration.append(header);
                declaration.append(className);
                code.insert(0, declaration);
                if (this.debug) {
                    File dir = new File("src/main/java/com/sampullara/mustaches/");
                    dir.mkdirs();
                    File file = new File(dir, className + ".java");
                    FileWriter fw = new FileWriter(file);
                    fw.write(code.toString());
                    fw.close();
                }
                RuntimeJavaCompiler.CompilerClassLoader loader = (RuntimeJavaCompiler.CompilerClassLoader)RuntimeJavaCompiler.compile(new PrintWriter(System.out, true), className, code.toString(), parent);
                Class<?> aClass = loader.loadClass("com.sampullara.mustaches." + className);
                result = (Mustache)aClass.newInstance();
                result.setRoot(this.root);
                if (this.outputDirectory != null) {
                    for (Map.Entry<String, RuntimeJavaCompiler.JavaClassOutput> entry : loader.getJavaClassMap().entrySet()) {
                        String outputName = entry.getKey();
                        int dot = outputName.lastIndexOf(".");
                        String outputPackage = outputName.substring(0, dot);
                        File outputDir = new File(this.outputDirectory, outputPackage.replace(".", "/"));
                        outputDir.mkdirs();
                        File outputFile = new File(outputDir, outputName.substring(dot + 1) + ".class");
                        FileOutputStream fos = new FileOutputStream(outputFile);
                        fos.write(entry.getValue().getBytes());
                        fos.close();
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MustacheException("Failed to compile code: " + e);
        }
        return result;
    }

    private void writeText(StringBuilder sb, String text) {
        if (text.length() != 0) {
            text = text.replace("\\", "\\\\");
            text = text.replace("\"", "\\\"");
            sb.append("w.write(\"").append(text).append("\");");
        }
    }
}

