/*
 * Decompiled with CFR 0.152.
 */
package com.sampullara.util;

import java.io.IOException;
import java.io.Writer;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class FutureWriter
extends Writer {
    private AppendableCallable last;
    private ConcurrentLinkedQueue<Future<Object>> ordered = new ConcurrentLinkedQueue();
    private static ExecutorService es = new ThreadPoolExecutor(10, 100, 60L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(10), new ThreadPoolExecutor.CallerRunsPolicy());
    private Writer writer;
    private boolean closed = false;
    int total = 0;

    public static void setExecutorService(ExecutorService es) {
        ExecutorService old = FutureWriter.es;
        FutureWriter.es = es;
        old.shutdown();
    }

    public FutureWriter() {
    }

    public FutureWriter(Writer writer) {
        this.writer = writer;
    }

    public Writer getWriter() {
        return this.writer;
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    public void enqueue(CharSequence cs) throws IOException {
        if (this.closed) {
            throw new IOException("closed");
        }
        if (this.last != null) {
            this.last.append(cs);
        } else {
            AppendableCallable call = new AppendableCallable(cs);
            this.enqueue(es.submit(call));
            this.last = call;
        }
    }

    public void enqueue(Callable<Object> callable) throws IOException {
        Future<Object> future = es.submit(callable);
        this.enqueue(future);
    }

    public void enqueue(Future<Object> future) throws IOException {
        if (this.closed) {
            throw new IOException("closed");
        }
        this.last = null;
        ++this.total;
        this.ordered.add(future);
    }

    @Override
    public void flush() throws IOException {
        this.flush(true);
    }

    public void flush(boolean top) throws IOException {
        try {
            for (Future<Object> work : this.ordered) {
                Object o;
                try {
                    o = work.get(50L, TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException te) {
                    this.writer.flush();
                    o = work.get();
                }
                if (o instanceof FutureWriter) {
                    FutureWriter fw = (FutureWriter)o;
                    fw.setWriter(this.writer);
                    fw.flush(false);
                } else if (o instanceof Future) {
                    Future future = (Future)o;
                    Object result = future.get();
                    if (result != null) {
                        this.writer.write(result.toString());
                    }
                } else if (o != null) {
                    this.writer.write(o.toString());
                }
                --this.total;
            }
            if (top) {
                this.writer.flush();
            }
            if (this.total != 0) {
                throw new AssertionError((Object)("Enqueued work != executed work: " + this.total));
            }
        }
        catch (Exception e) {
            throw new IOException("Failed to flush", e);
        }
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.writer.close();
        this.closed = true;
    }

    @Override
    public void write(int i) throws IOException {
        this.enqueue(String.valueOf((char)i));
    }

    @Override
    public void write(char[] chars, int i, int i1) throws IOException {
        this.enqueue(new String(chars, i, i1));
    }

    @Override
    public void write(String s, int i, int i1) throws IOException {
        this.enqueue(s.substring(i, i1));
    }

    @Override
    public void write(char[] chars) throws IOException {
        this.enqueue(new String(chars));
    }

    @Override
    public void write(String s) throws IOException {
        this.enqueue(s);
    }

    @Override
    public Writer append(CharSequence charSequence) throws IOException {
        this.enqueue(charSequence);
        return this;
    }

    @Override
    public Writer append(CharSequence charSequence, int i, int i1) throws IOException {
        this.enqueue(charSequence.subSequence(i, i1));
        return this;
    }

    @Override
    public Writer append(char c) throws IOException {
        this.enqueue(String.valueOf(c));
        return this;
    }

    private static class AppendableCallable
    implements Appendable,
    Callable<Object> {
        StringBuffer sb;

        AppendableCallable(CharSequence cs) {
            this.sb = new StringBuffer(cs);
        }

        @Override
        public Appendable append(CharSequence cs) {
            this.sb.append(cs);
            return this;
        }

        @Override
        public Appendable append(CharSequence charSequence, int i, int i1) throws IOException {
            this.sb.append(charSequence, i, i1);
            return this;
        }

        @Override
        public Appendable append(char c) throws IOException {
            this.sb.append(String.valueOf(c));
            return this;
        }

        @Override
        public Object call() throws Exception {
            return this.sb;
        }
    }
}

