/*
 * Decompiled with CFR 0.152.
 */
package com.sampullara.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;

public class RuntimeJavaCompiler {
    public static ClassLoader compile(PrintWriter printWriter, String className, String code) throws IOException {
        return RuntimeJavaCompiler.compile(printWriter, className, code, null);
    }

    public static ClassLoader compile(PrintWriter printWriter, String className, String code, ClassLoader loader) throws IOException {
        if (loader == null) {
            loader = Thread.currentThread().getContextClassLoader();
        }
        CompilerClassLoader ccl = new CompilerClassLoader(loader);
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        StandardJavaFileManager jfm = compiler.getStandardFileManager(null, null, null);
        ClassLoaderFileManager fjfm = new ClassLoaderFileManager(jfm, ccl, loader);
        ArrayList<JavaSourceFromString> sources = new ArrayList<JavaSourceFromString>();
        sources.add(new JavaSourceFromString(className, code));
        JavaCompiler.CompilationTask task = compiler.getTask(printWriter, fjfm, null, null, null, sources);
        task.call();
        return ccl;
    }

    public static class JavaSourceFromString
    extends SimpleJavaFileObject {
        private String code;

        public JavaSourceFromString(String name, String code) {
            super(URI.create("string:///" + name.replace('.', '/') + JavaFileObject.Kind.SOURCE.extension), JavaFileObject.Kind.SOURCE);
            this.code = code;
        }

        @Override
        public CharSequence getCharContent(boolean ignoreEncodingErrors) {
            return this.code;
        }
    }

    public static class ClassLoaderFileManager
    extends ForwardingJavaFileManager<StandardJavaFileManager> {
        private final CompilerClassLoader ccl;
        private final ClassLoader loader;

        public ClassLoaderFileManager(StandardJavaFileManager jfm, CompilerClassLoader ccl, ClassLoader loader) {
            super(jfm);
            this.ccl = ccl;
            this.loader = loader;
        }

        @Override
        public String inferBinaryName(JavaFileManager.Location location, JavaFileObject file) {
            String result;
            if (file instanceof JavaClassFromFile || file instanceof JavaClassFromEntry || file instanceof JavaClassOutput) {
                String name = file.getName();
                result = name = name.substring(0, name.length() - 6).replace('/', '.');
            } else {
                result = super.inferBinaryName(location, file);
            }
            return result;
        }

        @Override
        public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String classname, JavaFileObject.Kind kind, FileObject fileObject) throws IOException {
            if (kind == JavaFileObject.Kind.CLASS) {
                JavaClassOutput jco = new JavaClassOutput(URI.create("memory://" + classname.replace('.', '/') + ".class"), JavaFileObject.Kind.CLASS);
                this.ccl.add(classname, jco);
                return jco;
            }
            return super.getJavaFileForOutput(location, classname, kind, fileObject);
        }

        @Override
        public Iterable<JavaFileObject> list(JavaFileManager.Location location, String s, Set<JavaFileObject.Kind> kinds, boolean b) throws IOException {
            ArrayList<JavaFileObject> jfos = new ArrayList<JavaFileObject>();
            if (location.getName().equals("CLASS_PATH")) {
                Enumeration<URL> loaderurls;
                ClassLoader parent;
                String name = s.replace('.', '/');
                HashSet<URL> urls = new HashSet<URL>();
                if (this.loader instanceof CompilerClassLoader) {
                    jfos.addAll(((CompilerClassLoader)this.loader).getJavaClasses());
                    parent = this.loader;
                    while ((parent = parent.getParent()) instanceof CompilerClassLoader) {
                        jfos.addAll(((CompilerClassLoader)parent).getJavaClasses());
                    }
                    if (parent instanceof URLClassLoader) {
                        loaderurls = ((URLClassLoader)parent).findResources(name);
                        while (loaderurls.hasMoreElements()) {
                            urls.add(loaderurls.nextElement());
                        }
                    }
                }
                if (this.loader instanceof URLClassLoader) {
                    Enumeration<URL> loaderurls2 = ((URLClassLoader)this.loader).findResources(name);
                    while (loaderurls2.hasMoreElements()) {
                        urls.add(loaderurls2.nextElement());
                    }
                }
                if ((parent = this.loader.getParent()) instanceof URLClassLoader) {
                    loaderurls = ((URLClassLoader)parent).findResources(name);
                    while (loaderurls.hasMoreElements()) {
                        urls.add(loaderurls.nextElement());
                    }
                }
                for (URL url : urls) {
                    File file;
                    String filename = url.getFile();
                    String protocol = url.getProtocol();
                    if ("jar".equals(protocol)) {
                        String jarFilename = filename.substring(5);
                        if (!new File(jarFilename = jarFilename.substring(0, jarFilename.indexOf("!"))).exists()) continue;
                        JarFile jar = new JarFile(jarFilename);
                        Enumeration<JarEntry> entries = jar.entries();
                        while (entries.hasMoreElements()) {
                            JarEntry entry = entries.nextElement();
                            String entryName = entry.getName();
                            if (!entryName.startsWith(name) || entry.isDirectory()) continue;
                            jfos.add(new JavaClassFromEntry(jar, entry));
                        }
                        continue;
                    }
                    if (!"file".equals(protocol) || !(file = new File(filename)).exists()) continue;
                    if (file.isDirectory()) {
                        for (File entry : file.listFiles()) {
                            if (!entry.isFile()) continue;
                            jfos.add(new JavaClassFromFile(entry));
                        }
                        continue;
                    }
                    if (!file.isFile()) continue;
                    jfos.add(new JavaClassFromFile(file));
                }
            }
            for (JavaFileObject jfo : super.list(location, s, kinds, b)) {
                jfos.add(jfo);
            }
            return jfos;
        }
    }

    public static class CompilerClassLoader
    extends ClassLoader {
        private Map<String, JavaClassOutput> classes = new HashMap<String, JavaClassOutput>();

        public Map<String, JavaClassOutput> getJavaClassMap() {
            return this.classes;
        }

        public Collection<JavaClassOutput> getJavaClasses() {
            return this.classes.values();
        }

        public CompilerClassLoader(ClassLoader loader) {
            super(loader);
        }

        public void add(String name, JavaClassOutput clazz) {
            this.classes.put(name, clazz);
        }

        @Override
        protected URL findResource(String s) {
            if (s.startsWith("/")) {
                s = s.substring(1);
            }
            if (s.endsWith(".class")) {
                s = s.substring(0, s.length() - 6);
            }
            s = s.replace('/', '.');
            JavaClassOutput jco = this.classes.get(s);
            try {
                File tempFile = File.createTempFile("class", "bytes");
                FileOutputStream fos = new FileOutputStream(tempFile);
                fos.write(jco.getBytes());
                fos.close();
                return tempFile.toURI().toURL();
            }
            catch (IOException e) {
                return null;
            }
        }

        @Override
        protected Class<?> findClass(String classname) throws ClassNotFoundException {
            JavaClassOutput file = this.classes.get(classname);
            if (file != null) {
                byte[] bytes = file.getBytes();
                return this.defineClass(classname, bytes, 0, bytes.length);
            }
            try {
                return Class.forName(classname);
            }
            catch (ClassNotFoundException nf) {
                return super.findClass(classname);
            }
        }
    }

    public static class JavaClassOutput
    extends SimpleJavaFileObject {
        private ByteArrayOutputStream bytes;

        protected JavaClassOutput(URI uri, JavaFileObject.Kind kind) {
            super(uri, kind);
        }

        @Override
        public OutputStream openOutputStream() {
            this.bytes = new ByteArrayOutputStream();
            return this.bytes;
        }

        @Override
        public InputStream openInputStream() {
            return new ByteArrayInputStream(this.bytes.toByteArray());
        }

        public byte[] getBytes() {
            return this.bytes.toByteArray();
        }
    }

    public static class JavaClassFromEntry
    extends SimpleJavaFileObject {
        private JarFile jarfile;
        private ZipEntry entry;

        protected JavaClassFromEntry(JarFile jarfile, ZipEntry entry) {
            super(URI.create("jar://" + jarfile.getName() + "!" + entry.getName()), JavaFileObject.Kind.CLASS);
            this.jarfile = jarfile;
            this.entry = entry;
        }

        @Override
        public String getName() {
            return this.entry.getName();
        }

        @Override
        public InputStream openInputStream() throws IOException {
            return this.jarfile.getInputStream(this.entry);
        }
    }

    public static class JavaClassFromFile
    extends SimpleJavaFileObject {
        private File file;

        protected JavaClassFromFile(File file) {
            super(file.toURI(), JavaFileObject.Kind.CLASS);
            this.file = file;
        }

        @Override
        public InputStream openInputStream() throws IOException {
            return new FileInputStream(this.file);
        }
    }
}

