/*
 * Decompiled with CFR 0.152.
 */
package com.sampullara.util.http;

import com.sampullara.util.CallbackFuture;
import com.sampullara.util.http.HttpRequest;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.concurrent.Future;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.map.MappingJsonFactory;
import org.eclipse.jetty.client.ContentExchange;
import org.eclipse.jetty.client.HttpExchange;

public class JSONHttpRequest
extends HttpRequest<JsonNode> {
    private static MappingJsonFactory jf = new MappingJsonFactory();

    public JSONHttpRequest(String url) throws MalformedURLException {
        super(url);
    }

    @Override
    public Future<JsonNode> execute() throws IOException {
        final CallbackFuture<JsonNode> future = new CallbackFuture<JsonNode>();
        ContentExchange exchange = new ContentExchange(){

            protected void onResponseComplete() throws IOException {
                super.onResponseComplete();
                String responseContent = this.getResponseContent();
                if (responseContent == null) {
                    future.set(null);
                } else {
                    try {
                        JsonParser jp = jf.createJsonParser(responseContent);
                        future.set(jp.readValueAsTree());
                    }
                    catch (Exception e) {
                        future.error(e);
                    }
                }
            }
        };
        exchange.setRequestHeader("Accept", "application/json, text/javascript");
        exchange.setMethod("GET");
        exchange.setURL(this.url.toString());
        client.send((HttpExchange)exchange);
        return future;
    }
}

