/*
 * Decompiled with CFR 0.152.
 */
package play.modules.mustache;

import com.sampullara.mustache.MustacheCompiler;
import com.sampullara.mustache.MustacheException;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import play.Logger;
import play.Play;
import play.PlayPlugin;
import play.modules.mustache.MustacheSession;
import play.vfs.VirtualFile;

public class MustachePlugin
extends PlayPlugin {
    private static ThreadLocal<MustacheSession> session_ = new ThreadLocal();
    private static Map<String, String> fsTemplates_ = new HashMap<String, String>();

    public static MustacheSession session() {
        return session_.get();
    }

    public void onConfigurationRead() {
        String root = Play.configuration.containsKey("mustache.dir") ? Play.configuration.getProperty("mustache.dir") : Play.applicationPath + "/app/views/mustaches";
        MustacheCompiler compiler = new MustacheCompiler(new File(root));
        session_.set(new MustacheSession(compiler, root));
        try {
            this.loadFileSystemTemplates(root);
        }
        catch (Exception e) {
            Logger.error((String)("Error initializing Mustache module: " + e.getMessage()), (Object[])new Object[0]);
        }
        Logger.info((String)"Mustache module initialized", (Object[])new Object[0]);
    }

    private void loadFileSystemTemplates(String root) throws MustacheException, IOException {
        File dir = VirtualFile.open((String)root).getRealFile();
        this.addFilesRecursively(dir, root);
    }

    private void addFilesRecursively(File file, String root) throws MustacheException, IOException {
        File[] children = file.listFiles();
        if (children != null) {
            for (File child : children) {
                if (child.isDirectory()) {
                    this.addFilesRecursively(child, root);
                    continue;
                }
                String path = child.getAbsolutePath();
                String key = path.replace(root + "/", "");
                MustachePlugin.session().addFromFile(key, path);
            }
        }
    }
}

