/*
 * Decompiled with CFR 0.152.
 */
package com.sampullara.util.http;

import com.sampullara.util.CallbackFuture;
import com.sampullara.util.http.HttpRequest;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.concurrent.Future;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.jetty.client.ContentExchange;
import org.eclipse.jetty.client.HttpExchange;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLHttpRequest
extends HttpRequest<Document> {
    private static DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
    private static DocumentBuilder db;

    public XMLHttpRequest(String url) throws MalformedURLException {
        super(url);
    }

    @Override
    public Future<Document> execute() throws IOException {
        final CallbackFuture<Document> future = new CallbackFuture<Document>();
        ContentExchange exchange = new ContentExchange(){

            protected void onResponseComplete() throws IOException {
                super.onResponseComplete();
                String responseContent = this.getResponseContent();
                try {
                    future.set(db.parse(new InputSource(responseContent)));
                }
                catch (SAXException e) {
                    future.error(e);
                }
            }
        };
        exchange.setRequestHeader("Accept", "text/xml, application/xml");
        exchange.setMethod("GET");
        exchange.setURL(this.url.toExternalForm());
        client.send((HttpExchange)exchange);
        return future;
    }

    static {
        try {
            db = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new AssertionError((Object)("Failed to create document builder: " + e));
        }
    }
}

