/*
 * Decompiled with CFR 0.152.
 */
package play.modules.mustache;

import com.sampullara.mustache.Mustache;
import com.sampullara.mustache.MustacheCompiler;
import com.sampullara.mustache.MustacheException;
import com.sampullara.mustache.Scope;
import com.sampullara.util.FutureWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MustacheSession {
    private MustacheCompiler compiler_ = null;
    private String root_ = null;
    private Map<String, Mustache> loaded_ = new HashMap<String, Mustache>();
    private Map<String, String> raw_ = new HashMap<String, String>();

    public MustacheSession(MustacheCompiler compiler, String directory) {
        this.compiler_ = compiler;
        this.root_ = directory;
    }

    public Map<String, String> getRawTemplates() {
        return this.raw_;
    }

    public void addFromString(String key, String tmpl) throws MustacheException {
        this.loaded_.put(key, this.compiler_.parse(tmpl));
        this.raw_.put(key, tmpl);
    }

    public void addFromFile(String key, String path) throws MustacheException, IOException {
        String tmpl = this.readFile(path);
        this.addFromString(key, tmpl);
    }

    public String toHtml(String key, Object context) throws MustacheException, IOException {
        if (!this.loaded_.containsKey(key)) {
            this.addFromFile(key, this.root_ + key);
        }
        Mustache m = this.loaded_.get(key);
        StringWriter sw = new StringWriter();
        FutureWriter writer = new FutureWriter((Writer)sw);
        m.execute(writer, new Scope(context));
        writer.flush();
        return sw.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readFile(String path) throws IOException {
        FileInputStream stream = new FileInputStream(new File(path));
        try {
            FileChannel fc = stream.getChannel();
            MappedByteBuffer bb = fc.map(FileChannel.MapMode.READ_ONLY, 0L, fc.size());
            String string = Charset.defaultCharset().decode(bb).toString();
            return string;
        }
        finally {
            stream.close();
        }
    }
}

