/*
 *    Copyright 2009-2011 The MyBatis Team
 *
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */
package org.apache.ibatis.type;

import java.math.BigInteger;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class BigIntegerTypeHandler extends BaseTypeHandler<BigInteger> {

  @Override
  public void setNonNullParameter(PreparedStatement ps, int i, BigInteger parameter, JdbcType jdbcType)
      throws SQLException {
    ps.setLong(i, parameter.longValue());
  }

  @Override
  public BigInteger getNullableResult(ResultSet rs, String columnName)
      throws SQLException {
    return BigInteger.valueOf(rs.getLong(columnName));
  }

  @Override
  public BigInteger getNullableResult(ResultSet rs, int columnIndex)
      throws SQLException {
    return BigInteger.valueOf(rs.getLong(columnIndex));
  }

  @Override
  public BigInteger getNullableResult(CallableStatement cs, int columnIndex)
      throws SQLException {
    return BigInteger.valueOf(cs.getLong(columnIndex));
  }
}
