package mybatisplay.plugins;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;

import org.apache.log4j.Logger;

import play.Play;
import play.PlayPlugin;
import play.vfs.VirtualFile;

/**
 * This plugin will hook into detectChanges event and will watch for xml file
 * changes on classpath.
 * 
 * When a change is detected it will call onFileChanges if
 * {@link FileChangeCallback} is set
 * 
 * @author bftanase@gmail.com
 * 
 */
public class MyBatisPlugin extends PlayPlugin {
  private static Logger log = Logger.getLogger(MyBatisPlugin.class);

  private Map<String, Long> lastFileMap;

  private static MyBatisPlugin instance;
  
  private static class MyObservable extends Observable{
    public void setChanged(){
      super.setChanged();
    }
  };

  private MyObservable observable = new MyObservable();
  
  public MyBatisPlugin() {

    
    // we'll prevent multiple instantiations to avoid unknown side effects
    if (instance != null) {
      throw new IllegalStateException("This plugin has already been initialized");
    } else {
      instance = this;
    }

    log.info("mybatis plugin loaded");
  }

  @Override
  public void detectChange() {
    log.debug("Detecting changes ...");
    if (filesChanged()) {
      throw new RuntimeException("Change detected");
    }
    log.debug("No change detected ...");
    super.detectChange();
  }

  @Override
  public void onApplicationStart() {
    log.debug("File or class change detected");


    observable.setChanged();
    observable.notifyObservers();
      
    super.onApplicationStart();
  }

  private void buildDirTree(VirtualFile currentDirectory, Map<String, Long> fileMap) {
    List<VirtualFile> fileList = currentDirectory.list();

    for (VirtualFile file : fileList) {
      if (!file.isDirectory() && file.getName().endsWith("xml")) {
        fileMap.put(file.getRealFile().getPath(), file.lastModified());
      } else if (file.isDirectory()) {
        buildDirTree(file, fileMap);
      }
    }

    return;
  }

  private Map<String, Long> getFileMap() {
    Map<String, Long> fileMap = new HashMap<String, Long>();

    List<VirtualFile> pathList = Play.javaPath;

    for (VirtualFile virtualFile : pathList) {
      buildDirTree(virtualFile, fileMap);
    }

    return fileMap;
  }

  protected boolean filesChanged() {

    boolean result;

    // first run, no changes
    if (lastFileMap == null) {
      lastFileMap = getFileMap();
      return false;
    }

    Map<String, Long> currentFileMap = getFileMap();

    if (lastFileMap.equals(currentFileMap)) {
      result = false;
    } else {
      result = true;
    }

    lastFileMap = getFileMap();

    return result;
  }

  public static MyBatisPlugin getInstance() {
    return instance;
  }

  public void addObserver(Observer observer) {
    observable.addObserver(observer);
  }

}
