import urllib
import urllib2
import os
import imp
import tempfile
import time
import mmap
import stat
import signal
import getopt
import getpass
from play.utils import *
# Here you can create play commands that are specific to the module, and extend existing commands

MODULE = 'nemrod'

# Commands that are specific to your module

COMMANDS = ['nemrod:import']

HELP = {
    'nemrod:import': "Import translations from Nemrod",
}

# Created handler
redirectionHandler = urllib2.HTTPRedirectHandler() 
cookieprocessor = urllib2.HTTPCookieProcessor()

# 2 apply the handler to an opener
opener = urllib2.build_opener(redirectionHandler, cookieprocessor)

# 3. Install the openers
urllib2.install_opener(opener)


def load_module(name):
    base = os.path.normpath(os.path.dirname(os.path.realpath(sys.argv[0])))
    mod_desc = imp.find_module(name, [os.path.join(base, 'framework/pym')])
    return imp.load_module(name, mod_desc[0], mod_desc[1], mod_desc[2])

json = load_module('simplejson')

def execute(**kargs):
    command = kargs.get("command")
    app = kargs.get("app")
    args = kargs.get("args")
    env = kargs.get("env")
    
    projectname = app.readConf('nemrod.project.name')
    url = app.readConf('nemrod.url')
    login = app.readConf('nemrod.login')
    password = app.readConf('nemrod.password')
    languages = app.readConf('application.langs').split(',')
    exportemptyvalues = app.readConf('nemrod.exportemptyvalues')
    onlyapprovedvalues = app.readConf('nemrod.onlyapprovedvalues')

    def fetch(path, data=None):
        request = urllib2.Request('%s%s' % (url, path), data)
        request.add_header('Accept', 'application/json')
        result = urllib2.urlopen(request)    
        return result 

    def download(path, file_name="messages", data=None):

        request = urllib2.Request('%s%s' % (url, path), data)
        u = urllib2.urlopen(request)    
        
        file_name = "%s/conf/%s" % (app.path,file_name)
        f = open(file_name, 'wb')
        meta = u.info()
        file_size = int(meta.getheaders("Content-Length")[0])
        print "Downloading: %s Bytes: %s" % (file_name, file_size)

        file_size_dl = 0
        block_sz = 8192
        while True:
            buffer = u.read(block_sz)
            if not buffer:
                break

            file_size_dl += len(buffer)
            f.write(buffer)
            status = r"%10d  [%3.2f%%]" % (file_size_dl, file_size_dl * 100. / file_size)
            status = status + chr(8)*(len(status)+1)
            print status,

        f.close()    
    
    
    if command == "nemrod:import":
        print "~ Import:"
        print "~ Project: %s" % projectname
        print "~ url: %s" % url
    print '~'    
    print '~'
    
    try:
        values = {'username' : login, 'password' : password }
        data  = urllib.urlencode(values)
        loginRet = json.loads(fetch('login',  data).read())
        if loginRet['message'] == 'KO':
            print "~ Error : %s" % loginRet['errors'][0]
            sys.exit(-1)
    except urllib2.HTTPError, e:
        print '~ Cannot connect (%s)' % e.code
        print '~'
        sys.exit(-1)
    except urllib2.URLError, e:
        print '~ Cannot connect (%s)' % e.reason 
        print '~'
        sys.exit(-1)
    
    try:
        values = {}
        data  = urllib.urlencode(values)
        projects = json.loads(fetch('projects/index',  data).read())
        if not projects:
            print "~ No project available" 
            sys.exit(-1)
    except urllib2.HTTPError, e:
        print '~ Cannot connect (%s)' % e.code
        print '~'
        sys.exit(-1)

    for p in projects:
        if p['name'] == projectname:
            project = p
    if not project:
        print '~ Project (%s) do not exit on Nemrod. Available projects are %s' % (projectname,projects)
        print '~'
        sys.exit(-1)

    try:
        values = {"projectId":project['id']}
        data  = urllib.urlencode(values)
        locales = json.loads(fetch('projects/locales',  data).read())
        if not locales:
            print "~ No locales available" 
            sys.exit(-1)
    except urllib2.HTTPError, e:
        print '~ Cannot connect (%s)' % e.code
        print '~'
        sys.exit(-1)

    shortLocales = []
    for locale in locales:
        shortLocales.append(locale['language'])
    
    if shortLocales.sort() != languages.sort():
        print '~ Error : you should configure the same language on Nemrod and in application.conf' 
        print '~ Languages in application.conf : %s' % languages
        print '~ Languages in Nemrod : %s' % shortLocales    
        sys.exit(-1)

    try:
        values = {"projectId":project['id']}
        data  = urllib.urlencode(values)
        modules = json.loads(fetch('projects/modules',  data).read())
        if not modules:
            print "~ No modules available" 
            sys.exit(-1)
    except urllib2.HTTPError, e:
        print '~ Cannot connect (%s)' % e.code
        print '~'
        sys.exit(-1)        

    for m in modules:
        if m['name'] == 'messages':
            module = m
    if not module:
        print '~ Module messages do not exit on Nemrod.'
        print '~'
        sys.exit(-1)
        
    try:
        for l in locales:
            values = {"projectId":project['id'],"localeId":l['id'],"exporter":"utf8java","moduleId":m['id'],"exportemptyvalues":exportemptyvalues,"onlyapprovedvalues":onlyapprovedvalues}
            data  = urllib.urlencode(values)
            download('fileexporters/doexport', 'messages.%s' % (l['language']),  data)
            if l['id'] == project['localeByDefault']['id']:
                download('fileexporters/doexport', 'messages',  data)
                
    except urllib2.HTTPError, e:
        print '~ Cannot connect (%s)' % e.code
        print '~'
        sys.exit(-1)    
    
# This will be executed before any command (new, run...)
def before(**kargs):
    command = kargs.get("command")
    app = kargs.get("app")
    args = kargs.get("args")
    env = kargs.get("env")


# This will be executed after any command (new, run...)
def after(**kargs):
    command = kargs.get("command")
    app = kargs.get("app")
    args = kargs.get("args")
    env = kargs.get("env")

    if command == "new":
        pass
