/*
 * Decompiled with CFR 0.152.
 */
package com.nemrodsoftware;

import com.nemrodsoftware.INemrodClient;
import com.nemrodsoftware.model.Locale;
import com.nemrodsoftware.model.Module;
import com.nemrodsoftware.model.Project;
import com.nemrodsoftware.model.StatusMessage;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.client.apache.ApacheHttpClient;
import com.sun.jersey.client.apache.config.DefaultApacheHttpClientConfig;
import com.sun.jersey.core.header.ContentDisposition;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NemrodClient
implements INemrodClient {
    private static final Log LOG = LogFactory.getLog(NemrodClient.class);
    private final String url;
    private final String login;
    private final String password;
    private final Client client;
    private WebResource webResource;

    public NemrodClient(String url, String login, String password) {
        this.url = url;
        this.login = login;
        this.password = password;
        DefaultApacheHttpClientConfig cc = new DefaultApacheHttpClientConfig();
        cc.getFeatures().put("com.sun.jersey.api.json.POJOMappingFeature", Boolean.TRUE);
        cc.getProperties().put("com.sun.jersey.impl.client.httpclient.handleCookies", Boolean.TRUE);
        this.client = ApacheHttpClient.create((ClientConfig)cc);
        this.client.setFollowRedirects(Boolean.valueOf(true));
        this.webResource = this.client.resource(this.url);
    }

    @Override
    public boolean login() {
        MultivaluedMapImpl queryParams = new MultivaluedMapImpl();
        queryParams.add((Object)"username", (Object)this.login);
        queryParams.add((Object)"password", (Object)this.password);
        ClientResponse response = (ClientResponse)this.webResource.queryParams((MultivaluedMap)queryParams).path("/login").accept(new String[]{"application/json"}).post(ClientResponse.class);
        StatusMessage msg = (StatusMessage)response.getEntity(StatusMessage.class);
        if (!msg.getMessage().equals("OK")) {
            LOG.error((Object)("Error : " + msg.getErrors()));
            return false;
        }
        return true;
    }

    @Override
    public Project findProject(String projectName) {
        List<Project> projects = this.listProject();
        for (Project project : projects) {
            if (!project.getName().equals(projectName)) continue;
            return project;
        }
        return null;
    }

    @Override
    public List<Project> listProject() {
        GenericType<List<Project>> genericType = new GenericType<List<Project>>(){};
        List projects = (List)this.webResource.path("/projects/index").accept(new String[]{"application/json"}).get((GenericType)genericType);
        return projects;
    }

    @Override
    public List<Locale> listLocale(Project project) {
        GenericType<List<Locale>> genericType = new GenericType<List<Locale>>(){};
        MultivaluedMapImpl queryParams = new MultivaluedMapImpl();
        queryParams.add((Object)"projectId", (Object)project.getId().toString());
        List locales = (List)this.webResource.queryParams((MultivaluedMap)queryParams).path("/projects/locales").accept(new String[]{"application/json"}).get((GenericType)genericType);
        return locales;
    }

    @Override
    public Locale findLocale(Project project, String localeName) {
        List<Locale> locales = this.listLocale(project);
        for (Locale locale : locales) {
            if (!localeName.equalsIgnoreCase(locale.getIsoName())) continue;
            return locale;
        }
        return null;
    }

    @Override
    public List<Module> listModule(Project project) {
        GenericType<List<Module>> genericType = new GenericType<List<Module>>(){};
        MultivaluedMapImpl queryParams = new MultivaluedMapImpl();
        queryParams.add((Object)"projectId", (Object)project.getId().toString());
        List modules = (List)this.webResource.queryParams((MultivaluedMap)queryParams).path("/projects/modules").accept(new String[]{"application/json"}).get((GenericType)genericType);
        return modules;
    }

    @Override
    public Module findModule(Project project, String moduleName) {
        List<Module> modules = this.listModule(project);
        for (Module module : modules) {
            if (!module.getName().equals(moduleName)) continue;
            return module;
        }
        return null;
    }

    @Override
    public File export(Project project, Locale locale, Module module, String exportType, boolean exportEmptyValues, boolean exportOnlyApprovedValues, String workFolder) throws IOException {
        ContentDisposition cd;
        MultivaluedMapImpl queryParams = new MultivaluedMapImpl();
        queryParams.add((Object)"projectId", (Object)project.getId().toString());
        queryParams.add((Object)"localeId", (Object)locale.getId().toString());
        queryParams.add((Object)"moduleId", (Object)module.getId().toString());
        queryParams.add((Object)"exporter", (Object)exportType);
        queryParams.add((Object)"exportemptyvalues", (Object)Boolean.toString(exportEmptyValues));
        queryParams.add((Object)"onlyapprovedvalues", (Object)Boolean.toString(exportOnlyApprovedValues));
        ClientResponse response = (ClientResponse)this.webResource.queryParams((MultivaluedMap)queryParams).path("/fileexporters/doexport").accept(new String[]{"application/octet-stream"}).get(ClientResponse.class);
        String header = (String)response.getHeaders().getFirst((Object)"Content-Disposition");
        try {
            cd = new ContentDisposition(header);
        }
        catch (ParseException e) {
            throw new IllegalStateException("header Content-disposition not found or invalid.", e);
        }
        String filename = cd.getFileName();
        InputStream is = response.getEntityInputStream();
        File dest = new File(workFolder, filename);
        FileUtils.writeByteArrayToFile((File)dest, (byte[])IOUtils.toByteArray((InputStream)is));
        return dest;
    }
}

