/*
 * Decompiled with CFR 0.152.
 */
package com.nemrodsoftware.config;

import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;

public class NemrodConfiguration {
    private PropertiesConfiguration conf;

    public NemrodConfiguration(String fileName) throws ConfigurationException {
        this.conf = fileName != null ? new PropertiesConfiguration(fileName) : new PropertiesConfiguration();
    }

    public String getWorkFolder() {
        return this.getStringFromConfOrProperties("nemrod.export.workfolder", "");
    }

    public String getLogin() {
        return this.getStringFromConfOrProperties("nemrod.login");
    }

    public String getPassword() {
        return this.getStringFromConfOrProperties("nemrod.password");
    }

    public String getUrl() {
        return this.getStringFromConfOrProperties("nemrod.url");
    }

    public String getProjectName() {
        return this.getStringFromConfOrProperties("nemrod.project");
    }

    public String getLocale() {
        return this.getStringFromConfOrProperties("nemrod.locale");
    }

    public String getModule() {
        return this.getStringFromConfOrProperties("nemrod.module");
    }

    public String getExportFormat() {
        return this.getStringFromConfOrProperties("nemrod.exportformat");
    }

    public boolean exportEmptyValues() {
        return this.getBooleanFromConfOrProperties("nemrod.exportoptions.empty.values", true);
    }

    public boolean exportOnlyApprovedValues() {
        return this.getBooleanFromConfOrProperties("nemrod.exportoptions.only.approved.values", false);
    }

    private String getStringFromConfOrProperties(String key, String defaultValue) {
        String value = this.conf.getString(key, defaultValue);
        value = System.getProperty(key, value);
        return value;
    }

    private String getStringFromConfOrProperties(String key) {
        String value = (String)this.conf.getProperty(key);
        value = System.getProperty(key, value);
        return value;
    }

    private boolean getBooleanFromConfOrProperties(String key, boolean defaultValue) {
        String value = this.conf.getString(key, Boolean.toString(defaultValue));
        value = System.getProperty(key, value);
        return Boolean.valueOf(value);
    }
}

