/*
 * Decompiled with CFR 0.152.
 */
package com.nemrodsoftware.action;

import com.nemrodsoftware.INemrodClient;
import com.nemrodsoftware.config.NemrodConfiguration;
import com.nemrodsoftware.model.Locale;
import com.nemrodsoftware.model.Module;
import com.nemrodsoftware.model.Project;
import java.io.File;
import java.io.IOException;
import javax.security.auth.login.FailedLoginException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExportAction {
    private static final Log LOG = LogFactory.getLog(ExportAction.class);
    private final NemrodConfiguration conf;
    private final INemrodClient client;

    public ExportAction(NemrodConfiguration conf, INemrodClient client) {
        this.conf = conf;
        this.client = client;
    }

    public void execute() throws IOException, FailedLoginException {
        String projectName = this.conf.getProjectName();
        String localeName = this.conf.getLocale();
        String exportType = this.conf.getExportFormat();
        String moduleName = this.conf.getModule();
        String modulePath = this.conf.getModulePath();
        String workFolder = this.conf.getWorkFolder();
        if (StringUtils.isEmpty((String)projectName)) {
            throw new IllegalArgumentException("Project name is not set. Please set nemrod.project property");
        }
        if (StringUtils.isEmpty((String)localeName)) {
            throw new IllegalArgumentException("Locale name is not set. Please set nemrod.locale property");
        }
        if (StringUtils.isEmpty((String)exportType)) {
            throw new IllegalArgumentException("Export type is not set. Please set nemrod.exportformat property");
        }
        if (StringUtils.isEmpty((String)moduleName)) {
            throw new IllegalArgumentException("Module name is not set. Please set nemrod.module property");
        }
        boolean exportEmptyValues = this.conf.exportEmptyValues();
        boolean exportOnlyApprovedValues = this.conf.exportOnlyApprovedValues();
        if (!this.client.login()) {
            throw new FailedLoginException("Unable to login");
        }
        Project project = this.client.findProject(projectName);
        if (project == null) {
            throw new IllegalArgumentException("Project not found on nemrod instance. Please check project name in the configuration.");
        }
        Locale locale = this.client.findLocale(project, localeName);
        if (locale == null) {
            throw new IllegalArgumentException("Locale not found on nemrod instance. Please check if this locale is configured in the configuration and on Nemrod.");
        }
        Module module = this.client.findModule(project, moduleName, modulePath);
        if (module == null) {
            throw new IllegalArgumentException("Module not found on nemrod instance for this project. Please check project configuration.");
        }
        File file = this.client.export(project, locale, module, exportType, exportEmptyValues, exportOnlyApprovedValues, workFolder);
        LOG.info((Object)("Download file=" + file.getAbsolutePath() + " - OK"));
    }
}

