/*
 * Decompiled with CFR 0.152.
 */
package play.modules.nemrod;

import com.nemrodsoftware.INemrodClient;
import com.nemrodsoftware.model.Module;
import java.io.File;
import java.io.IOException;
import javax.security.auth.login.FailedLoginException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import play.modules.nemrod.NemrodConfiguration;

public class ExportAction {
    private static final Log LOG = LogFactory.getLog(ExportAction.class);
    private final NemrodConfiguration conf;
    private final INemrodClient client;

    public ExportAction(NemrodConfiguration conf, INemrodClient client) {
        this.conf = conf;
        this.client = client;
    }

    public void execute() throws IOException, FailedLoginException {
        String projectName = this.conf.getProjectName();
        String localeName = this.conf.getLocale();
        String exportType = this.conf.getExportFormat();
        String moduleName = this.conf.getModule();
        String modulePath = this.conf.getModulePath();
        String workFolder = this.conf.getWorkFolder();
        if (StringUtils.isEmpty((String)projectName)) {
            throw new IllegalArgumentException("Project name is not set. Please set nemrod.project property");
        }
        if (StringUtils.isEmpty((String)localeName)) {
            throw new IllegalArgumentException("Locale name is not set. Please set nemrod.locale property");
        }
        if (StringUtils.isEmpty((String)exportType)) {
            throw new IllegalArgumentException("Export type is not set. Please set nemrod.exportformat property");
        }
        if (StringUtils.isEmpty((String)moduleName)) {
            throw new IllegalArgumentException("Module name is not set. Please set nemrod.module property");
        }
        boolean exportEmptyValues = this.conf.exportEmptyValues();
        boolean exportOnlyApprovedValues = this.conf.exportOnlyApprovedValues();
        Module module = this.client.findModule(projectName, moduleName, modulePath);
        if (module == null) {
            throw new IllegalArgumentException("Module not found on nemrod instance for this project. Please check project configuration.");
        }
        File file = this.client.export(projectName, localeName, module, exportType, exportEmptyValues, exportOnlyApprovedValues, workFolder);
        LOG.info((Object)("Download file=" + file.getAbsolutePath() + " - OK"));
    }
}

