/*
 * Decompiled with CFR 0.152.
 */
package play.modules.nemrod;

import com.nemrodsoftware.INemrodClient;
import com.nemrodsoftware.NemrodClient;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import play.modules.nemrod.ExportAction;
import play.modules.nemrod.NemrodConfiguration;
import play.modules.nemrod.SyncAction;

public class Nemrod {
    public static void main(String[] args) throws Exception {
        Options options = new Options();
        OptionBuilder.withArgName((String)"action");
        OptionBuilder.hasArg((boolean)true);
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"Action");
        Option action = OptionBuilder.create((String)"a");
        options.addOption(action);
        PosixParser parser = new PosixParser();
        CommandLine cmd = null;
        try {
            cmd = parser.parse(options, args);
        }
        catch (ParseException e) {
            HelpFormatter helpFormatter = new HelpFormatter();
            helpFormatter.setWidth(80);
            helpFormatter.printHelp("See options below", "Nemrod options:", options, "");
            System.exit(1);
        }
        NemrodConfiguration conf = new NemrodConfiguration();
        NemrodClient client = new NemrodClient(conf.getUrl(), conf.getApiKey());
        if (cmd.getOptionValue("a").equals("export")) {
            ExportAction exportAction = new ExportAction(conf, (INemrodClient)client);
            exportAction.execute();
        } else if (cmd.getOptionValue("a").equals("sync")) {
            SyncAction syncAction = new SyncAction(conf, (INemrodClient)client);
            syncAction.execute();
        }
    }
}

