/*
 * Decompiled with CFR 0.152.
 */
package play.modules.nemrod;

import com.nemrodsoftware.INemrodClient;
import com.nemrodsoftware.model.Module;
import java.io.File;
import java.io.IOException;
import javax.security.auth.login.FailedLoginException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import play.modules.nemrod.NemrodConfiguration;

public class SyncAction {
    private static final Log LOG = LogFactory.getLog(SyncAction.class);
    private final NemrodConfiguration conf;
    private final INemrodClient client;

    public SyncAction(NemrodConfiguration conf, INemrodClient client) {
        this.conf = conf;
        this.client = client;
    }

    public void execute() throws IOException, FailedLoginException {
        String projectName = this.conf.getProjectName();
        String format = this.conf.getSyncFormat();
        String moduleName = this.conf.getModule();
        String modulePath = this.conf.getModulePath();
        File masterFile = this.conf.getMasterFile();
        if (StringUtils.isEmpty((String)projectName)) {
            throw new IllegalArgumentException("Project name is not set. Please set nemrod.project property");
        }
        if (StringUtils.isEmpty((String)format)) {
            throw new IllegalArgumentException("Format is not set. Please set nemrod.syncformat property");
        }
        if (StringUtils.isEmpty((String)moduleName)) {
            throw new IllegalArgumentException("Module name is not set. Please set nemrod.module property");
        }
        if (masterFile == null || !masterFile.exists()) {
            throw new IllegalArgumentException("Master file is invalid. Please set a valid path to the master file nemrod.sync.masterfile.path property");
        }
        Module module = this.client.findModule(projectName, moduleName, modulePath);
        if (module == null) {
            throw new IllegalArgumentException("Module not found on nemrod instance for this project. Please check project configuration.");
        }
        this.client.sync(projectName, format, module, masterFile);
        LOG.info((Object)("Sync master file=" + masterFile.getAbsolutePath() + " - OK"));
    }
}

