/*
 * Decompiled with CFR 0.152.
 */
package com.nemrodsoftware;

import com.nemrodsoftware.INemrodClient;
import com.nemrodsoftware.exception.OperationException;
import com.nemrodsoftware.model.Locale;
import com.nemrodsoftware.model.Module;
import com.nemrodsoftware.model.Project;
import com.nemrodsoftware.model.StatusMessage;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.client.apache.ApacheHttpClient;
import com.sun.jersey.client.apache.config.DefaultApacheHttpClientConfig;
import com.sun.jersey.core.header.ContentDisposition;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import com.sun.jersey.multipart.BodyPart;
import com.sun.jersey.multipart.FormDataMultiPart;
import com.sun.jersey.multipart.file.FileDataBodyPart;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.List;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class NemrodClient
implements INemrodClient {
    private final String url;
    private final String apikey;
    private final Client client;
    private WebResource webResource;

    public NemrodClient(String url, String apikey) {
        this.url = url;
        this.apikey = apikey;
        DefaultApacheHttpClientConfig cc = new DefaultApacheHttpClientConfig();
        cc.getFeatures().put("com.sun.jersey.api.json.POJOMappingFeature", Boolean.TRUE);
        cc.getProperties().put("com.sun.jersey.impl.client.httpclient.handleCookies", Boolean.TRUE);
        this.client = ApacheHttpClient.create((ClientConfig)cc);
        this.client.setFollowRedirects(Boolean.valueOf(true));
        this.webResource = this.client.resource(this.url);
    }

    @Override
    public List<Locale> listLocale(String project) {
        GenericType<List<Locale>> genericType = new GenericType<List<Locale>>(){};
        List locales = (List)this.webResource.queryParam("apikey", this.apikey).path("/api/locales/" + project).accept(new String[]{"application/json"}).get((GenericType)genericType);
        return locales;
    }

    @Override
    public List<Module> listModule(String project) {
        GenericType<List<Module>> genericType = new GenericType<List<Module>>(){};
        List modules = (List)this.webResource.queryParam("apikey", this.apikey).path("/api/modules/" + project).accept(new String[]{"application/json"}).get((GenericType)genericType);
        return modules;
    }

    @Override
    public Module findModule(String project, String moduleName, String modulePath) {
        List<Module> modules = this.listModule(project);
        for (Module module : modules) {
            if (!module.getName().equals(moduleName) || !module.getFullpath().equals(modulePath)) continue;
            return module;
        }
        return null;
    }

    @Override
    public File export(String project, String localeName, Module module, String exportType, boolean exportEmptyValues, boolean exportOnlyApprovedValues, String workFolder) throws IOException {
        ContentDisposition cd;
        MultivaluedMapImpl queryParams = new MultivaluedMapImpl();
        queryParams.add((Object)"exportemptyvalues", (Object)Boolean.toString(exportEmptyValues));
        queryParams.add((Object)"onlyapprovedvalues", (Object)Boolean.toString(exportOnlyApprovedValues));
        queryParams.add((Object)"apikey", (Object)this.apikey);
        ClientResponse response = (ClientResponse)this.webResource.queryParams((MultivaluedMap)queryParams).path("/api/translations/" + project + "/" + exportType + "/" + localeName + "/" + module.getId()).accept(new String[]{"application/octet-stream"}).get(ClientResponse.class);
        if (response.getStatus() != 200) {
            throw new OperationException("Status code=" + response.getStatus());
        }
        String header = (String)response.getHeaders().getFirst((Object)"Content-Disposition");
        try {
            cd = new ContentDisposition(header);
        }
        catch (ParseException e) {
            throw new IllegalStateException("header Content-disposition not found or invalid. Header found=" + header, e);
        }
        String filename = cd.getFileName();
        InputStream is = response.getEntityInputStream();
        File dest = new File(workFolder, filename);
        FileUtils.writeByteArrayToFile((File)dest, (byte[])IOUtils.toByteArray((InputStream)is));
        return dest;
    }

    @Override
    public void sync(String project, String format, Module module, File masterFile) {
        FormDataMultiPart form = new FormDataMultiPart();
        form.bodyPart((BodyPart)new FileDataBodyPart("masterFile", masterFile, MediaType.APPLICATION_OCTET_STREAM_TYPE));
        ClientResponse response = (ClientResponse)((WebResource.Builder)this.webResource.queryParam("apikey", this.apikey).path("/api/sync/" + project + "/" + format + "/" + module.getId()).type(MediaType.MULTIPART_FORM_DATA_TYPE).accept(new String[]{"application/json"})).post(ClientResponse.class, (Object)form);
        this.checkStatusMessage(response);
    }

    @Override
    public void create(Project project) {
        ClientResponse response = (ClientResponse)this.webResource.queryParam("apikey", this.apikey).queryParam("project.name", project.getName()).queryParam("project.description", project.getDescription()).queryParam("project.isPublic", project.getIsPublic().toString()).queryParam("project.nbMaxLocale", project.getNbMaxLocale().toString()).queryParam("project.nbMaxUser", project.getNbMaxUser().toString()).queryParam("project.nbMaxMessage", project.getNbMaxMessage().toString()).path("/api/project").accept(new String[]{"application/json"}).post(ClientResponse.class);
        this.checkStatusMessage(response);
    }

    @Override
    public void delete(String projectName) {
        ClientResponse response = (ClientResponse)this.webResource.queryParam("apikey", this.apikey).path("/api/project/" + projectName).accept(new String[]{"application/json"}).delete(ClientResponse.class);
        this.checkStatusMessage(response);
    }

    @Override
    public void setVisibility(String projectName, Boolean isPublic) {
        ClientResponse response = (ClientResponse)this.webResource.queryParam("apikey", this.apikey).queryParam("isPublic", isPublic.toString()).path("/api/conf/visibility/" + projectName).accept(new String[]{"application/json"}).put(ClientResponse.class);
        this.checkStatusMessage(response);
    }

    @Override
    public void setNbMaxUser(String projectName, Long nbMaxUser) {
        ClientResponse response = (ClientResponse)this.webResource.queryParam("apikey", this.apikey).queryParam("nbMaxUser", nbMaxUser.toString()).path("/api/conf/users/" + projectName).accept(new String[]{"application/json"}).put(ClientResponse.class);
        this.checkStatusMessage(response);
    }

    @Override
    public void setNbMaxLocale(String projectName, Long nbMaxLocale) {
        ClientResponse response = (ClientResponse)this.webResource.queryParam("apikey", this.apikey).queryParam("nbMaxLocale", nbMaxLocale.toString()).path("/api/conf/locales/" + projectName).accept(new String[]{"application/json"}).put(ClientResponse.class);
        this.checkStatusMessage(response);
    }

    @Override
    public void setNbMaxMessage(String projectName, Long nbMaxMessage) {
        ClientResponse response = (ClientResponse)this.webResource.queryParam("apikey", this.apikey).queryParam("nbMaxMessage", nbMaxMessage.toString()).path("/api/conf/messages/" + projectName).accept(new String[]{"application/json"}).put(ClientResponse.class);
        this.checkStatusMessage(response);
    }

    @Override
    public Long getNbMaxMessage(String projectName) {
        ClientResponse response = (ClientResponse)this.webResource.queryParam("apikey", this.apikey).path("/api/conf/messages/" + projectName).accept(new String[]{"application/json"}).get(ClientResponse.class);
        if (response.getStatus() != 200) {
            throw new OperationException("Status code=" + response.getStatus());
        }
        StatusMessage msg = (StatusMessage)response.getEntity(StatusMessage.class);
        return Long.valueOf(msg.getDetail());
    }

    @Override
    public Long getNbMaxLocale(String projectName) {
        ClientResponse response = (ClientResponse)this.webResource.queryParam("apikey", this.apikey).path("/api/conf/locales/" + projectName).accept(new String[]{"application/json"}).get(ClientResponse.class);
        if (response.getStatus() != 200) {
            throw new OperationException("Status code=" + response.getStatus());
        }
        StatusMessage msg = (StatusMessage)response.getEntity(StatusMessage.class);
        return Long.valueOf(msg.getDetail());
    }

    @Override
    public Long getNbMaxUser(String projectName) {
        ClientResponse response = (ClientResponse)this.webResource.queryParam("apikey", this.apikey).path("/api/conf/users/" + projectName).accept(new String[]{"application/json"}).get(ClientResponse.class);
        if (response.getStatus() != 200) {
            throw new OperationException("Status code=" + response.getStatus());
        }
        StatusMessage msg = (StatusMessage)response.getEntity(StatusMessage.class);
        return Long.valueOf(msg.getDetail());
    }

    @Override
    public void addMember(String projectName, String login) {
        ClientResponse response = (ClientResponse)this.webResource.queryParam("apikey", this.apikey).path("/api/member/" + projectName + "/" + login).accept(new String[]{"application/json"}).post(ClientResponse.class);
        this.checkStatusMessage(response);
    }

    private void checkStatusMessage(ClientResponse response) {
        if (response.getStatus() != 200) {
            throw new OperationException("Status code=" + response.getStatus());
        }
    }
}

