package play.modules.nemrod;

import java.io.File;

import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;

/**
 * Nemrod configuration utility
 * 
 * This utility is able to read configuration from a file and override every values
 * by a system property if found. 
 *
 */
public class NemrodConfiguration 
{
    private PropertiesConfiguration conf ;

    public NemrodConfiguration(String fileName) throws ConfigurationException
    {
        conf = new PropertiesConfiguration(fileName);
    }
    
    public NemrodConfiguration() throws ConfigurationException
    {
        conf = new PropertiesConfiguration();
    }    

    public String getWorkFolder()
    {
        return getStringFromConfOrProperties("nemrod.export.workfolder","");
    }   
    
    public void setWorkFolder(String workFolder)
    {
        conf.setProperty("nemrod.export.workfolder", workFolder);
    }

    public File getMasterFile()
    {
        return getFileFromConfOrProperties("nemrod.sync.masterfile.path","");
    }
    
    public void setMasterFile(String property)
    {
        conf.setProperty("nemrod.sync.masterfile.path", property);
    }

    
    public String getApiKey()
    {
        return getStringFromConfOrProperties("nemrod.apikey");
    }

    public void setApiKey(String property)
    {
        conf.setProperty("nemrod.apikey", property);
    }    
    
    public String getUrl()
    {
        return getStringFromConfOrProperties("nemrod.url");
    }

    public void setUrl(String property)
    {
        conf.setProperty("nemrod.url", property);
    }
    
    public String getProjectName()
    {
        return getStringFromConfOrProperties("nemrod.project");
    }
    
    public void setProjectName(String property)
    {
        conf.setProperty("nemrod.project", property);
    }
    
    public String getLocale()
    {
        return getStringFromConfOrProperties("nemrod.locale");
    }
    
    public void setLocale(String property)
    {
        conf.setProperty("nemrod.locale", property);
    }    

    public String getModule()
    {
        return getStringFromConfOrProperties("nemrod.module");
    }
    
    public void setModule(String property)
    {
        conf.setProperty("nemrod.module", property);
    }       
    
    public String getModulePath()
    {
        return getStringFromConfOrProperties("nemrod.module.path","");
    }    
    
    public void setModulePath(String property)
    {
        conf.setProperty("nemrod.module.path", property);
    }     

    public String getExportFormat()
    {
        return getStringFromConfOrProperties("nemrod.exportformat");
    }
    
    public void setExportFormat(String property)
    {
        conf.setProperty("nemrod.exportformat", property);
    }         
    
    public String getSyncFormat()
    {
        return getStringFromConfOrProperties("nemrod.syncformat");
    }    
    
    public void setSyncFormat(String property)
    {
        conf.setProperty("nemrod.syncformat", property);
    }           

    public boolean exportEmptyValues()
    {
        return getBooleanFromConfOrProperties("nemrod.exportoptions.empty.values",true);
    }
    
    public void setExportEmptyValues(Boolean property)
    {
        conf.setProperty("nemrod.exportoptions.empty.values", property.toString());
    }       

    public boolean exportOnlyApprovedValues()
    {
        return getBooleanFromConfOrProperties("nemrod.exportoptions.only.approved.values",false);
    }
    
    public void setExportOnlyApprovedValues(Boolean property)
    {
        conf.setProperty("nemrod.exportoptions.only.approved.values", property.toString());
    }     

    private String getStringFromConfOrProperties(String key, String defaultValue)
    {
        String value = conf.getString(key,defaultValue);
        value = System.getProperty(key,value);
        return value;
    }

    private File getFileFromConfOrProperties(String key, String defaultValue)
    {
        String value = conf.getString(key,defaultValue);
        value = System.getProperty(key,value);
        return new File(value);
    }
    
    
    private String getStringFromConfOrProperties(String key)
    {
        String value = (String)conf.getProperty(key);
        value = System.getProperty(key,value);
        return value;
    }
    
    private boolean getBooleanFromConfOrProperties(String key, boolean defaultValue)
    {
        String value = conf.getString(key,Boolean.toString(defaultValue));
        value = System.getProperty(key,value);
        return Boolean.valueOf(value);
    }
}
