package play.modules.nemrod;

import java.io.File;
import java.io.IOException;

import javax.security.auth.login.FailedLoginException;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.nemrodsoftware.INemrodClient;
import com.nemrodsoftware.model.Module;

public class SyncAction
{
    private static final Log LOG = LogFactory.getLog(SyncAction.class);
    
    private final NemrodConfiguration conf;
    private final INemrodClient client;
    
    public SyncAction(NemrodConfiguration conf, INemrodClient client)
    {
        this.conf = conf;
        this.client = client;
    }

    public void execute() throws IOException, FailedLoginException
    {
        String projectName = conf.getProjectName();
        String format = conf.getSyncFormat();
        String moduleName = conf.getModule();
        String modulePath = conf.getModulePath();
        File masterFile = conf.getMasterFile();
        
        if (StringUtils.isEmpty(projectName))
                throw new IllegalArgumentException("Project name is not set. Please set nemrod.project property");
        if (StringUtils.isEmpty(format))
            throw new IllegalArgumentException("Format is not set. Please set nemrod.syncformat property");
        if (StringUtils.isEmpty(moduleName))
            throw new IllegalArgumentException("Module name is not set. Please set nemrod.module property");
        if (masterFile == null || !masterFile.exists())
            throw new IllegalArgumentException("Master file is invalid. Please set a valid path to the master file nemrod.sync.masterfile.path property");
        
        Module module = client.findModule(projectName,moduleName,modulePath);
        if (module==null)
        {
            throw new IllegalArgumentException("Module not found on nemrod instance for this project. Please check project configuration.");
        }
        
        client.sync(projectName, format, module, masterFile);
        
        LOG.info("Sync master file="+masterFile.getAbsolutePath()+" - OK");
        
    }

}
