/*
 * Decompiled with CFR 0.152.
 */
package play.modules.nemrod;

import java.io.File;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;

public class NemrodConfiguration {
    private PropertiesConfiguration conf;

    public NemrodConfiguration(String fileName) throws ConfigurationException {
        this.conf = new PropertiesConfiguration(fileName);
    }

    public NemrodConfiguration() throws ConfigurationException {
        this.conf = new PropertiesConfiguration();
    }

    public String getWorkFolder() {
        return this.getStringFromConfOrProperties("nemrod.export.workfolder", "");
    }

    public void setWorkFolder(String workFolder) {
        this.conf.setProperty("nemrod.export.workfolder", (Object)workFolder);
    }

    public File getMasterFile() {
        return this.getFileFromConfOrProperties("nemrod.sync.masterfile.path", "");
    }

    public void setMasterFile(String property) {
        this.conf.setProperty("nemrod.sync.masterfile.path", (Object)property);
    }

    public String getApiKey() {
        return this.getStringFromConfOrProperties("nemrod.apikey");
    }

    public void setApiKey(String property) {
        this.conf.setProperty("nemrod.apikey", (Object)property);
    }

    public String getUrl() {
        return this.getStringFromConfOrProperties("nemrod.url");
    }

    public void setUrl(String property) {
        this.conf.setProperty("nemrod.url", (Object)property);
    }

    public String getProjectName() {
        return this.getStringFromConfOrProperties("nemrod.project");
    }

    public void setProjectName(String property) {
        this.conf.setProperty("nemrod.project", (Object)property);
    }

    public String getLocale() {
        return this.getStringFromConfOrProperties("nemrod.locale");
    }

    public void setLocale(String property) {
        this.conf.setProperty("nemrod.locale", (Object)property);
    }

    public String getModule() {
        return this.getStringFromConfOrProperties("nemrod.module");
    }

    public void setModule(String property) {
        this.conf.setProperty("nemrod.module", (Object)property);
    }

    public String getModulePath() {
        return this.getStringFromConfOrProperties("nemrod.module.path", "");
    }

    public void setModulePath(String property) {
        this.conf.setProperty("nemrod.module.path", (Object)property);
    }

    public String getExportFormat() {
        return this.getStringFromConfOrProperties("nemrod.exportformat");
    }

    public void setExportFormat(String property) {
        this.conf.setProperty("nemrod.exportformat", (Object)property);
    }

    public String getSyncFormat() {
        return this.getStringFromConfOrProperties("nemrod.syncformat");
    }

    public void setSyncFormat(String property) {
        this.conf.setProperty("nemrod.syncformat", (Object)property);
    }

    public boolean exportEmptyValues() {
        return this.getBooleanFromConfOrProperties("nemrod.exportoptions.empty.values", true);
    }

    public void setExportEmptyValues(Boolean property) {
        this.conf.setProperty("nemrod.exportoptions.empty.values", (Object)property.toString());
    }

    public boolean exportOnlyApprovedValues() {
        return this.getBooleanFromConfOrProperties("nemrod.exportoptions.only.approved.values", false);
    }

    public void setExportOnlyApprovedValues(Boolean property) {
        this.conf.setProperty("nemrod.exportoptions.only.approved.values", (Object)property.toString());
    }

    private String getStringFromConfOrProperties(String key, String defaultValue) {
        String value = this.conf.getString(key, defaultValue);
        value = System.getProperty(key, value);
        return value;
    }

    private File getFileFromConfOrProperties(String key, String defaultValue) {
        String value = this.conf.getString(key, defaultValue);
        value = System.getProperty(key, value);
        return new File(value);
    }

    private String getStringFromConfOrProperties(String key) {
        String value = (String)this.conf.getProperty(key);
        value = System.getProperty(key, value);
        return value;
    }

    private boolean getBooleanFromConfOrProperties(String key, boolean defaultValue) {
        String value = this.conf.getString(key, Boolean.toString(defaultValue));
        value = System.getProperty(key, value);
        return Boolean.valueOf(value);
    }
}

