package play.modules.nemrod;

import java.io.File;
import java.io.IOException;

import javax.security.auth.login.FailedLoginException;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.nemrodsoftware.INemrodClient;
import com.nemrodsoftware.model.Module;

public class ExportAction
{
    private static final Log LOG = LogFactory.getLog(ExportAction.class);
    
    private final NemrodConfiguration conf;
    private final INemrodClient client;
    
    public ExportAction(NemrodConfiguration conf, INemrodClient client)
    {
        this.conf = conf;
        this.client = client;
    }

    public void execute() throws IOException, FailedLoginException
    {
        String projectName = conf.getProjectName();
        String localeName = conf.getLocale();
        String exportType = conf.getExportFormat();
        String moduleName = conf.getModule();
        String modulePath = conf.getModulePath();
        String workFolder = conf.getWorkFolder();
        
        if (StringUtils.isEmpty(projectName))
                throw new IllegalArgumentException("Project name is not set. Please set nemrod.project property");
        if (StringUtils.isEmpty(localeName))
            throw new IllegalArgumentException("Locale name is not set. Please set nemrod.locale property");
        if (StringUtils.isEmpty(exportType))
            throw new IllegalArgumentException("Export type is not set. Please set nemrod.exportformat property");
        if (StringUtils.isEmpty(moduleName))
            throw new IllegalArgumentException("Module name is not set. Please set nemrod.module property");
        
        boolean exportEmptyValues = conf.exportEmptyValues();
        boolean exportOnlyApprovedValues = conf.exportOnlyApprovedValues();

        Module module = client.findModule(projectName,moduleName, modulePath);
        if (module==null)
        {
            throw new IllegalArgumentException("Module not found on nemrod instance for this project. Please check project configuration.");
        }
        
        File file = client.export(projectName, localeName, module, exportType, exportEmptyValues, exportOnlyApprovedValues, workFolder);
        
        LOG.info("Download file="+file.getAbsolutePath()+" - OK");
        
    }

}
